/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.item.rarity.IRarity;
import ru.xewe.immortal.item.rarity.IRarityTier;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;
import ru.xewe.immortal.utils.ItemRarityHelper;

public abstract class AbstractRarityWeapon<T extends SwordItem>
extends SwordItem
implements IRarityTier<T> {
    AbstractRarityWeapon(Item.Properties properties) {
        super((Tier)RarityTiers.COMMON, 0, 0.0f, properties);
    }

    public static UUID getBaseAttackDamageUUID() {
        return f_41374_;
    }

    public static UUID getBaseAttackSpeedUUID() {
        return f_41375_;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return equipmentSlot.equals((Object)EquipmentSlot.MAINHAND) ? this.getAttributeModifiersWithRarity(stack) : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public Component m_7626_(ItemStack stack) {
        return this.getRarityTooltip(super.m_7626_(stack).m_6881_(), stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return ((RarityTiers)this.getRarityMaterialsMap().get((Object)ItemRarityHelper.getRarity(stack))).m_6609_();
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON;
    }

    public boolean isDamageable(ItemStack stack) {
        return ((RarityTiers)this.getRarityMaterialsMap().get((Object)ItemRarityHelper.getRarity(stack))).m_6609_() != -1;
    }

    public void onPickup(Player player) {
    }

    public void onPutAway(Player player) {
    }

    public void updateUpgradedInHand(Level world, Player player) {
    }

    public void updateInInventory(Level world, Player player) {
    }

    public void setCooldown(Player player, int cooldownTicks, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        player.m_36335_().m_41524_(item.m_41720_(), cooldownTicks);
    }

    public boolean isNotCooldown(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        return !player.m_36335_().m_41519_(item.m_41720_());
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        IRarity rarityItem;
        Item item;
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        ItemStack heldItem = player.m_21205_();
        if (heldItem.equals(stack) && (item = heldItem.m_41720_()) instanceof IRarity && (rarityItem = (IRarity)item).hasSkill(heldItem)) {
            this.updateUpgradedInHand(level, player);
        } else {
            this.updateInInventory(level, player);
        }
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        TooltipItem.appendShiftHoverText(pStack, pTooltipComponents, new Object[0]);
    }
}

