/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.weapons;

import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.item.weapons.StaffItem;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.item.rarity.IRarityTier;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import ru.xewe.immortal.item.weapons.tiers.RarityTiers;
import ru.xewe.immortal.utils.ItemRarityHelper;

public abstract class AbstractCastingRarityWeapon<T extends StaffItem>
extends StaffItem
implements IRarityTier<T> {
    public static final UUID UUID_WIZARDRY = UUID.fromString("667ad88f-901d-4691-b2a2-3664e42026d3");
    RarityTiers tier = RarityTiers.COMMON;

    protected AbstractCastingRarityWeapon(Item.Properties properties, Map<Attribute, AttributeModifier> additionalAttributes) {
        super(properties, 0.0, 0.0, additionalAttributes);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        return equipmentSlot.equals((Object)EquipmentSlot.MAINHAND) ? this.getAttributeModifiersWithRarity(stack) : super.getAttributeModifiers(equipmentSlot, stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return ((RarityTiers)this.getRarityMaterialsMap().get((Object)ItemRarityHelper.getRarity(stack))).m_6609_();
    }

    public boolean isDamageable(ItemStack stack) {
        return ((RarityTiers)this.getRarityMaterialsMap().get((Object)ItemRarityHelper.getRarity(stack))).m_6609_() != -1;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return this.tier.m_6282_().test(pRepair) || super.m_6832_(pToRepair, pRepair);
    }

    public boolean isRepairable(ItemStack stack) {
        return this.isDamageable(stack);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pEntityLiving) {
        if (pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0f) {
            pStack.m_41622_(2, pEntityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        TooltipItem.appendShiftHoverText(pStack, pTooltipComponents, new Object[0]);
    }

    public Component m_7626_(ItemStack pStack) {
        return this.getRarityTooltip(super.m_7626_(pStack).m_6881_(), pStack);
    }
}

