/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.tooltip.RarityTooltip;
import ru.xewe.immortal.utils.ItemRarityHelper;

@OnlyIn(value=Dist.CLIENT)
public class RarityTooltipComponent
implements ClientTooltipComponent {
    private final RarityTooltip rarityTooltip;

    public RarityTooltipComponent(RarityTooltip rarityTooltip) {
        this.rarityTooltip = rarityTooltip;
    }

    public int m_142103_() {
        return 8;
    }

    public int m_142069_(Font font) {
        int nameWidth = this.getXOffset();
        return nameWidth + this.getWidthTexture() + 4;
    }

    public void m_183452_(Font font, int x, int y, GuiGraphics guiGraphics) {
        ResourceLocation texture = this.getRarity().getTextureTooltip();
        PoseStack poseStack = guiGraphics.m_280168_();
        int xOff = this.getXOffset();
        poseStack.m_85836_();
        poseStack.m_252880_((float)xOff - 4.0f, -12.0f, 500.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.m_280163_(texture, x, y, 0.0f, 0.0f, this.getWidthTexture(), 8, 64, 16);
        poseStack.m_85849_();
    }

    public ItemRarity getRarity() {
        return ItemRarityHelper.getRarity(this.rarityTooltip.itemStack());
    }

    public int getXOffset() {
        return Minecraft.m_91087_().f_91062_.m_92895_(this.rarityTooltip.itemStack().m_41611_().getString());
    }

    public int getWidthTexture() {
        return switch (this.getRarity()) {
            default -> throw new IncompatibleClassChangeError();
            case ItemRarity.COMMON -> 39;
            case ItemRarity.RARE -> 24;
            case ItemRarity.EPIC -> 23;
            case ItemRarity.LEGENDARY -> 53;
        };
    }
}

