/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.rarity;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public enum ItemRarity {
    COMMON("common", "\ue000"),
    RARE("rare", "\ue001"),
    EPIC("epic", "\ue002"),
    LEGENDARY("legendary", "\ue003");

    private final ResourceLocation textureTooltip;
    private final ResourceLocation textureAltar;
    private final Component iconComponent;
    private final String name;
    public static final ItemRarity[] SEQUENCE_RARITY;
    private final ResourceLocation locationFont = new ResourceLocation("immortalskills", "rarity");

    private ItemRarity(String name, String iconInFont) {
        this.name = name;
        this.textureTooltip = new ResourceLocation("immortalskills", "textures/gui/tooltip/" + name + "_icon.png");
        this.textureAltar = new ResourceLocation("immortalskills", "textures/gui/" + name + "_gui_icon.png");
        this.iconComponent = Component.m_237113_((String)iconInFont).m_130948_(Style.f_131099_.m_131150_(this.locationFont).m_131140_(ChatFormatting.WHITE));
    }

    public int getTier() {
        return this.ordinal();
    }

    public ResourceLocation getTextureTooltip() {
        return this.textureTooltip;
    }

    public ResourceLocation getTextureAltar() {
        return this.textureAltar;
    }

    public Component getIconComponent() {
        return this.iconComponent;
    }

    static {
        SEQUENCE_RARITY = ItemRarity.values();
    }
}

