/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.rarity;

import com.google.common.collect.Multimap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.rarity.RarityStats;
import ru.xewe.immortal.utils.ItemRarityHelper;

public interface IRarity<T extends Item, I extends RarityStats> {
    public RegistryObject<T> getVariant();

    default public boolean hasSkill(ItemStack stack) {
        return ItemRarityHelper.hasMinRarity(stack, ItemRarity.RARE);
    }

    default public boolean improvesAtAltar(ItemStack stack) {
        return true;
    }

    default public Multimap<Attribute, AttributeModifier> getAttributeModifiersWithRarity(ItemStack stack) {
        ItemRarity rarity = ItemRarityHelper.getRarity(stack);
        return this.getAttributeModifiersWithRarity(rarity);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiersWithRarity(ItemRarity var1);

    default public Map<ItemRarity, I> getRarityMaterialsMap() {
        EnumMap<ItemRarity, I> materials = new EnumMap<ItemRarity, I>(this.getDefaultMaterials());
        for (RarityStats material : this.getRarityMaterials()) {
            materials.put(material.getRarity(), material);
        }
        return materials;
    }

    default public MutableComponent getRarityTooltip(MutableComponent component, ItemStack stack) {
        Component icon = ItemRarityHelper.getRarity(stack).getIconComponent();
        return component.m_130946_(" ").m_7220_(icon);
    }

    public Map<ItemRarity, I> getDefaultMaterials();

    public List<I> getRarityMaterials();
}

