/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor.materials;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.rarity.ItemRarity;
import ru.xewe.immortal.item.rarity.RarityStats;
import ru.xewe.immortal.utils.TripleMap;

public class RarityArmorMaterial
implements ArmorMaterial,
RarityStats {
    private static final Map<ItemRarity, TripleMap<ArmorItem.Type, Integer, Integer>> STATS_FOR_RARITY = new EnumMap<ItemRarity, TripleMap<ArmorItem.Type, Integer, Integer>>(ItemRarity.class);
    public static final RarityArmorMaterial COMMON;
    public static final RarityArmorMaterial RARE;
    public static final RarityArmorMaterial EPIC;
    public static final RarityArmorMaterial LEGENDARY;
    public static final RarityArmorMaterial EPIC_UNHOLY;
    public static final RarityArmorMaterial LEGENDARY_UNHOLY;
    public static final RarityArmorMaterial RARE_MECHANICAL;
    public static final RarityArmorMaterial EPIC_MECHANICAL;
    public static final RarityArmorMaterial LEGENDARY_MECHANICAL;
    public static final RarityArmorMaterial EPIC_INQUISITOR;
    public static final RarityArmorMaterial LEGENDARY_INQUISITOR;
    public static final RarityArmorMaterial RARE_ENGINEER;
    public static final RarityArmorMaterial EPIC_ENGINEER;
    public static final RarityArmorMaterial LEGENDARY_ENGINEER;
    public static final RarityArmorMaterial COMMON_ELEMENTALIST;
    public static final RarityArmorMaterial RARE_ELEMENTALIST;
    public static final RarityArmorMaterial EPIC_ELEMENTALIST;
    public static final RarityArmorMaterial LEGENDARY_ELEMENTALIST;
    public static final RarityArmorMaterial COMMON_ELDER_WIZARD;
    public static final RarityArmorMaterial RARE_ELDER_WIZARD;
    public static final RarityArmorMaterial EPIC_ELDER_WIZARD;
    public static final RarityArmorMaterial LEGENDARY_ELDER_WIZARD;
    private final ItemRarity rarity;
    private final String name;
    private float toughness;
    private float knockbackResistance;
    private int mana;
    private float multiplySpellPower;
    private TripleMap<ArmorItem.Type, Integer, Integer> overrideStats = new TripleMap();

    RarityArmorMaterial(ItemRarity rarity, float toughness, float knockbackResistance, int mana, float multiplySpellPower) {
        this.rarity = rarity;
        this.name = rarity.name().toLowerCase();
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.mana = mana;
        this.multiplySpellPower = multiplySpellPower;
    }

    RarityArmorMaterial(ItemRarity rarity) {
        this(rarity, 0.0f, 0.0f, 0, 0.0f);
    }

    RarityArmorMaterial(RarityArmorMaterial material) {
        this(material.rarity, material.toughness, material.knockbackResistance, material.mana, material.multiplySpellPower);
    }

    @Override
    public RarityArmorMaterial copy() {
        return new RarityArmorMaterial(this);
    }

    private RarityArmorMaterial overrideDef(ArmorItem.Type type, int defensive) {
        this.overrideStats.put(type, STATS_FOR_RARITY.get((Object)this.rarity).getOne(type), defensive);
        return this;
    }

    private RarityArmorMaterial overrideDef(Map<ArmorItem.Type, Integer> mapDef) {
        for (Map.Entry<ArmorItem.Type, Integer> entry : mapDef.entrySet()) {
            this.overrideDef(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public int m_266425_(ArmorItem.Type type) {
        return STATS_FOR_RARITY.get((Object)this.rarity).getOne(type);
    }

    public int m_7366_(ArmorItem.Type type) {
        if (this.overrideStats.hasKey(type)) {
            return this.overrideStats.getTwo(type);
        }
        return STATS_FOR_RARITY.get((Object)this.rarity).getTwo(type);
    }

    public int m_6646_() {
        return 1;
    }

    @NotNull
    public SoundEvent m_7344_() {
        return SoundEvents.f_11673_;
    }

    @NotNull
    public Ingredient m_6230_() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RegisterManagerItems.GEM.get()});
    }

    @Override
    public ItemRarity getRarity() {
        return this.rarity;
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    private RarityArmorMaterial setToughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    private RarityArmorMaterial setKnockbackResistance(float knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
        return this;
    }

    public int getMana() {
        return this.mana;
    }

    private RarityArmorMaterial setMana(int mana) {
        this.mana = mana;
        return this;
    }

    public float getMultiplySpellPower() {
        return this.multiplySpellPower;
    }

    private RarityArmorMaterial setMultiplySpellPower(float multiplySpellPower) {
        this.multiplySpellPower = multiplySpellPower;
        return this;
    }

    public TripleMap<ArmorItem.Type, Integer, Integer> getOverrideStats() {
        return this.overrideStats;
    }

    static {
        STATS_FOR_RARITY.put(ItemRarity.COMMON, TripleMap.of(ArmorItem.Type.HELMET, 165, 2, ArmorItem.Type.CHESTPLATE, 240, 6, ArmorItem.Type.LEGGINGS, 225, 5, ArmorItem.Type.BOOTS, 195, 2));
        STATS_FOR_RARITY.put(ItemRarity.RARE, TripleMap.of(ArmorItem.Type.HELMET, 363, 3, ArmorItem.Type.CHESTPLATE, 528, 8, ArmorItem.Type.LEGGINGS, 495, 6, ArmorItem.Type.BOOTS, 429, 3));
        STATS_FOR_RARITY.put(ItemRarity.EPIC, TripleMap.of(ArmorItem.Type.HELMET, 407, 3, ArmorItem.Type.CHESTPLATE, 592, 8, ArmorItem.Type.LEGGINGS, 555, 6, ArmorItem.Type.BOOTS, 481, 3));
        STATS_FOR_RARITY.put(ItemRarity.LEGENDARY, TripleMap.of(ArmorItem.Type.HELMET, -1, 3, ArmorItem.Type.CHESTPLATE, -1, 8, ArmorItem.Type.LEGGINGS, -1, 6, ArmorItem.Type.BOOTS, -1, 3));
        COMMON = new RarityArmorMaterial(ItemRarity.COMMON);
        RARE = new RarityArmorMaterial(ItemRarity.RARE);
        EPIC = new RarityArmorMaterial(ItemRarity.EPIC);
        LEGENDARY = new RarityArmorMaterial(ItemRarity.LEGENDARY);
        EPIC_UNHOLY = EPIC.copy().setToughness(2.0f).setKnockbackResistance(1.0f);
        LEGENDARY_UNHOLY = LEGENDARY.copy().setToughness(3.0f).setKnockbackResistance(1.0f).overrideDef(Map.of(ArmorItem.Type.HELMET, 4, ArmorItem.Type.CHESTPLATE, 9, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 4));
        RARE_MECHANICAL = RARE.copy().setKnockbackResistance(1.0f);
        EPIC_MECHANICAL = EPIC.copy().setToughness(2.0f).setKnockbackResistance(1.0f);
        LEGENDARY_MECHANICAL = LEGENDARY.copy().setToughness(3.0f).setKnockbackResistance(1.0f).overrideDef(Map.of(ArmorItem.Type.HELMET, 4, ArmorItem.Type.CHESTPLATE, 8, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 4));
        EPIC_INQUISITOR = EPIC.copy().setToughness(2.0f);
        LEGENDARY_INQUISITOR = LEGENDARY.copy().setToughness(3.0f).overrideDef(Map.of(ArmorItem.Type.HELMET, 4, ArmorItem.Type.CHESTPLATE, 8, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 4));
        RARE_ENGINEER = RARE.copy().setToughness(2.0f);
        EPIC_ENGINEER = EPIC.copy().setToughness(3.0f);
        LEGENDARY_ENGINEER = LEGENDARY.copy().setToughness(3.0f).overrideDef(Map.of(ArmorItem.Type.HELMET, 4, ArmorItem.Type.CHESTPLATE, 9, ArmorItem.Type.LEGGINGS, 6, ArmorItem.Type.BOOTS, 4));
        COMMON_ELEMENTALIST = COMMON.copy().setMana(10);
        RARE_ELEMENTALIST = RARE.copy().setMana(30);
        EPIC_ELEMENTALIST = EPIC.copy().setMana(60).setMultiplySpellPower(0.05f);
        LEGENDARY_ELEMENTALIST = LEGENDARY.copy().setToughness(3.0f).setMana(60).setMultiplySpellPower(0.1f);
        COMMON_ELDER_WIZARD = COMMON.copy().setMana(20);
        RARE_ELDER_WIZARD = RARE.copy().setMana(60);
        EPIC_ELDER_WIZARD = EPIC.copy().setMana(100).setToughness(2.0f);
        LEGENDARY_ELDER_WIZARD = LEGENDARY.copy().setToughness(3.0f).setMana(120);
    }
}

