/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor.materials;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.world.item.ArmorItem;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.utils.DuoMap;

public class ArmorSet<T extends ArmorItem> {
    private final DuoMap<ArmorItem.Type, RegistryObject<T>> SET = new DuoMap();

    public ArmorSet(RegistryObject<T> helmet, RegistryObject<T> chestplate, RegistryObject<T> leggings, RegistryObject<T> boots) {
        this.SET.put(ArmorItem.Type.HELMET, helmet);
        this.SET.put(ArmorItem.Type.CHESTPLATE, chestplate);
        this.SET.put(ArmorItem.Type.LEGGINGS, leggings);
        this.SET.put(ArmorItem.Type.BOOTS, boots);
    }

    public Collection<RegistryObject<T>> getList() {
        return this.SET.values();
    }

    public Collection<T> getListItems() {
        ArrayList<ArmorItem> armorItems = new ArrayList<ArmorItem>();
        for (RegistryObject<T> armor : this.getList()) {
            armorItems.add((ArmorItem)armor.get());
        }
        return armorItems;
    }

    public RegistryObject<T> get(ArmorItem.Type type) {
        return this.SET.get(type);
    }

    public RegistryObject<T> getHelmet() {
        return this.SET.get(ArmorItem.Type.HELMET);
    }

    public RegistryObject<T> getChestplate() {
        return this.SET.get(ArmorItem.Type.CHESTPLATE);
    }

    public RegistryObject<T> getLeggings() {
        return this.SET.get(ArmorItem.Type.LEGGINGS);
    }

    public RegistryObject<T> getBoots() {
        return this.SET.get(ArmorItem.Type.BOOTS);
    }
}

