/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor.handler;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.UnholyKnightArmor;
import ru.xewe.immortal.item.weapons.AbstractRarityWeapon;

@Mod.EventBusSubscriber(modid="immortalskills", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EquipEventHandler {
    @SubscribeEvent
    public static void onArmorEquip(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack newItem = event.getTo();
            ItemStack oldItem = event.getFrom();
            boolean changeItem = oldItem.m_41720_() != newItem.m_41720_();
            EquipmentSlot.Type slot = event.getSlot().m_20743_();
            if (changeItem) {
                if (slot.equals((Object)EquipmentSlot.Type.ARMOR)) {
                    AbstractRarityArmor armor;
                    Item item = newItem.m_41720_();
                    if (item instanceof AbstractRarityArmor) {
                        armor = (AbstractRarityArmor)item;
                        armor.onEquip(player);
                    }
                    if ((item = oldItem.m_41720_()) instanceof AbstractRarityArmor) {
                        armor = (AbstractRarityArmor)item;
                        armor.onUnequip(player);
                    }
                } else if (slot.equals((Object)EquipmentSlot.Type.HAND)) {
                    AbstractRarityWeapon weapon;
                    Item item = newItem.m_41720_();
                    if (item instanceof AbstractRarityWeapon) {
                        weapon = (AbstractRarityWeapon)item;
                        weapon.onPickup(player);
                    }
                    if ((item = oldItem.m_41720_()) instanceof AbstractRarityWeapon) {
                        weapon = (AbstractRarityWeapon)item;
                        weapon.onPutAway(player);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        if (item instanceof UnholyKnightArmor) {
            UnholyKnightArmor armor = (UnholyKnightArmor)item;
            event.setCanceled(!armor.canEquip(itemStack, null, (Entity)player));
        }
    }
}

