/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.Config;
import ru.xewe.immortal.client.renderer.armor.MechanicalMessengerRender;
import ru.xewe.immortal.effect.ExtendedShieldEffect;
import ru.xewe.immortal.effect.RegisterManagerEffects;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class MechanicalMessengerArmor
extends AbstractRarityArmor<MechanicalMessengerArmor> {
    private static int getCooldownAbility() {
        return Config.MechanicalMessengerArmorCoolDown;
    }

    public MechanicalMessengerArmor(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new MechanicalMessengerRender();
    }

    @Override
    public void initSkillFullArmor(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MechanicalMessengerArmor.setArmorCooldown((Player)serverPlayer, MechanicalMessengerArmor.getCooldownAbility());
        }
    }

    @Override
    public void updateOnSkillFullArmor(Level world, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (MechanicalMessengerArmor.isArmorNotCooldown(player)) {
                ((ExtendedShieldEffect)((Object)RegisterManagerEffects.SHIELD_EFFECT.get())).addEffect((LivingEntity)serverPlayer, 10, 0);
            }
        }
    }

    public void unDamageShield(ServerPlayer player) {
        player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 1.0f, 1.0f);
        MechanicalMessengerArmor.setArmorCooldown((Player)player, MechanicalMessengerArmor.getCooldownAbility());
    }

    @Override
    public ArmorSet<MechanicalMessengerArmor> getSet() {
        return RegisterManagerItems.MECHANICAL_MESSENGER_SET;
    }

    @Override
    public List<RarityArmorMaterial> getRarityMaterials() {
        return List.of(RarityArmorMaterial.RARE_MECHANICAL, RarityArmorMaterial.EPIC_MECHANICAL, RarityArmorMaterial.LEGENDARY_MECHANICAL);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        TooltipItem.appendShiftHoverText(stack, components, MechanicalMessengerArmor.getCooldownAbility() / 20);
    }
}

