/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.client.renderer.armor.ElementalistRender;
import ru.xewe.immortal.entity.ElementalSoul;
import ru.xewe.immortal.entity.FireSoulEntity;
import ru.xewe.immortal.entity.IceSoulEntity;
import ru.xewe.immortal.entity.NatureSoulEntity;
import ru.xewe.immortal.entity.SphereEntity;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class ElementalistArmor
extends AbstractRarityArmor<ElementalistArmor> {
    private static final int COOLDOWN_ABILITY = 1200;

    public ElementalistArmor(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new ElementalistRender();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(RawAnimation.begin().thenLoop("animation_idle"));
            return PlayState.CONTINUE;
        })});
    }

    @Override
    public void initSkillFullArmor(Player player) {
        ElementalistArmor.setArmorCooldown(player, 1200);
    }

    @Override
    public void updateOnSkillFullArmor(Level world, Player player) {
        if (!world.f_46443_ && ElementalistArmor.isArmorNotCooldown(player) && ElementalistArmor.getListElementalSouls(world, player).size() < 3) {
            ElementalistArmor.createSphere(player, world);
        }
    }

    @Override
    public void onUnequip(Player player) {
        for (SphereEntity sphereEntity : ElementalistArmor.getListElementalSouls(player.m_9236_(), player)) {
            sphereEntity.m_146870_();
        }
    }

    private static List<? extends SphereEntity> getListElementalSouls(Level world, Player player) {
        return world.m_45976_(SphereEntity.class, player.m_20191_().m_82400_(20.0)).stream().filter(soul -> soul.m_269323_() == player && soul instanceof ElementalSoul).toList();
    }

    private static void createSphere(Player player, Level level) {
        List<? extends SphereEntity> spheres = ElementalistArmor.getListElementalSouls(level, player);
        SphereEntity sphere = ElementalistArmor.getSphereEntity(player, level, spheres);
        if (sphere != null) {
            sphere.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            level.m_7967_((Entity)sphere);
            ElementalistArmor.setArmorCooldown(player, 1200);
        }
    }

    @Nullable
    private static SphereEntity getSphereEntity(Player player, Level level, List<? extends SphereEntity> spheres) {
        boolean hasFire = false;
        boolean hasIce = false;
        boolean hasNature = false;
        for (SphereEntity sphereEntity : spheres) {
            if (sphereEntity instanceof FireSoulEntity) {
                hasFire = true;
            }
            if (sphereEntity instanceof IceSoulEntity) {
                hasIce = true;
            }
            if (!(sphereEntity instanceof NatureSoulEntity)) continue;
            hasNature = true;
        }
        SphereEntity sphere = null;
        if (!hasFire) {
            sphere = new FireSoulEntity(level, player);
        } else if (!hasIce) {
            sphere = new IceSoulEntity(level, player);
        } else if (!hasNature) {
            sphere = new NatureSoulEntity(level, player);
        }
        return sphere;
    }

    @Override
    public ArmorSet<ElementalistArmor> getSet() {
        return RegisterManagerItems.ELEMENTALIST_SET;
    }

    @Override
    public List<RarityArmorMaterial> getRarityMaterials() {
        return List.of(RarityArmorMaterial.COMMON_ELEMENTALIST, RarityArmorMaterial.RARE_ELEMENTALIST, RarityArmorMaterial.EPIC_ELEMENTALIST, RarityArmorMaterial.LEGENDARY_ELEMENTALIST);
    }
}

