/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.item.armor;

import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.setup.Messages;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.Config;
import ru.xewe.immortal.client.renderer.armor.ElderWizardRender;
import ru.xewe.immortal.effect.ExtendedShieldEffect;
import ru.xewe.immortal.effect.RegisterManagerEffects;
import ru.xewe.immortal.item.RegisterManagerItems;
import ru.xewe.immortal.item.armor.AbstractRarityArmor;
import ru.xewe.immortal.item.armor.materials.ArmorSet;
import ru.xewe.immortal.item.armor.materials.RarityArmorMaterial;
import ru.xewe.immortal.item.tooltip.TooltipItem;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class ElderWizardArmor
extends AbstractRarityArmor<ElderWizardArmor> {
    private static final int REQ_MANA = 60;

    public static int getCooldownAbility() {
        return Config.ElderWizardArmorCoolDown;
    }

    public ElderWizardArmor(ArmorItem.Type type, Item.Properties properties) {
        super(type, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GeoArmorRenderer<?> supplyRenderer() {
        return new ElderWizardRender();
    }

    @Override
    public ArmorSet<ElderWizardArmor> getSet() {
        return RegisterManagerItems.ELDER_WIZARD_SET;
    }

    @Override
    public void initSkillFullArmor(Player player) {
        boolean isSetCooldown;
        boolean bl = isSetCooldown = player.m_21124_((MobEffect)RegisterManagerEffects.MAGIC_SHIELD_EFFECT.get()) == null || player.m_21124_((MobEffect)RegisterManagerEffects.MAGIC_SHIELD_EFFECT.get()).m_19564_() == 0;
        if (isSetCooldown) {
            ElderWizardArmor.setArmorCooldown(player, ElderWizardArmor.getCooldownAbility());
        }
    }

    @Override
    public void updateOnSkillFullArmor(Level world, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (ElderWizardArmor.isArmorNotCooldown(player)) {
                this.effectFullArmor(serverPlayer);
            }
        }
    }

    @Override
    public void exitOnSkillFullArmor(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((ExtendedShieldEffect)((Object)RegisterManagerEffects.MAGIC_SHIELD_EFFECT.get())).removeEffect((LivingEntity)serverPlayer);
        }
    }

    public void effectFullArmor(ServerPlayer player) {
        int defaultAmplifier;
        MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)player);
        MobEffectInstance playerEffect = player.m_21124_((MobEffect)RegisterManagerEffects.MAGIC_SHIELD_EFFECT.get());
        boolean notEffect = playerEffect == null;
        int n = defaultAmplifier = notEffect ? -1 : playerEffect.m_19564_();
        if (defaultAmplifier <= 0 && magicData.getMana() >= 60.0f) {
            float newMana = Math.max(magicData.getMana() - 60.0f, 0.0f);
            magicData.setMana(newMana);
            Messages.sendToPlayer((Object)new ClientboundSyncMana(magicData), (ServerPlayer)player);
            if (defaultAmplifier != 0) {
                ElderWizardArmor.setArmorCooldown((Player)player, ElderWizardArmor.getCooldownAbility());
            }
            ((ExtendedShieldEffect)((Object)RegisterManagerEffects.MAGIC_SHIELD_EFFECT.get())).addEffect((LivingEntity)player, ElderWizardArmor.getCooldownAbility() + 10, defaultAmplifier + 1);
            player.m_9236_().m_5594_(null, player.m_20097_(), SoundEvents.f_11862_, SoundSource.PLAYERS, 1.0f, 1.0f);
        } else if (defaultAmplifier == 1) {
            ((ExtendedShieldEffect)((Object)RegisterManagerEffects.MAGIC_SHIELD_EFFECT.get())).addEffect((LivingEntity)player, ElderWizardArmor.getCooldownAbility() + 10, 1);
        }
    }

    @Override
    public List<RarityArmorMaterial> getRarityMaterials() {
        return List.of(RarityArmorMaterial.COMMON_ELDER_WIZARD, RarityArmorMaterial.EPIC_ELDER_WIZARD, RarityArmorMaterial.RARE_ELDER_WIZARD, RarityArmorMaterial.LEGENDARY_ELDER_WIZARD);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        TooltipItem.appendShiftHoverText(stack, components, ElderWizardArmor.getCooldownAbility() / 20);
    }
}

