/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.events;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immortalskills", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TimeableManager {
    private static final HashMap<Runnable, Integer> ACTIONS = new HashMap();

    public static void postDelayed(Runnable action, int ticks) {
        ACTIONS.put(action, ticks);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TimeableManager.runActions();
        }
    }

    private static void runActions() {
        Iterator<Map.Entry<Runnable, Integer>> iterator = ACTIONS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Runnable, Integer> entry = iterator.next();
            int ticks = entry.getValue();
            if (ticks > 0) {
                entry.setValue(ticks - 1);
                continue;
            }
            entry.getKey().run();
            iterator.remove();
        }
    }
}

