/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import ru.xewe.immortal.entity.CustomLightningBolt;
import ru.xewe.immortal.utils.RenderUtil;

public class CustomLightningRenderer
extends EntityRenderer<CustomLightningBolt> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[9];

    public CustomLightningRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CustomLightningBolt entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        int stage = entity.getAnimationStage();
        ResourceLocation texture = TEXTURES[stage];
        Vec3 size = new Vec3(5.0, 10.0, 5.0);
        float height = entity.m_20206_();
        Vec3 offset = new Vec3(0.0, (double)height + 2.7, 0.0);
        RenderUtil.renderIcon(poseStack, buffer, 0xF000F0, partialTicks, entity.m_20318_(partialTicks), offset, size, texture);
    }

    public ResourceLocation getTextureLocation(CustomLightningBolt entity) {
        return TEXTURES[entity.getAnimationStage()];
    }

    static {
        for (int i = 0; i < 9; ++i) {
            CustomLightningRenderer.TEXTURES[i] = new ResourceLocation("immortalskills", "textures/entity/lightning/thunder_" + (i + 1) + ".png");
        }
    }
}

