/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.entity.projectiles;

import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import ru.xewe.immortal.network.HitSpawnParticleToC;
import ru.xewe.immortal.network.ctx.PacketHandler;
import ru.xewe.immortal.utils.ParticleBuilder;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractMagicProjectile
extends ThrowableProjectile
implements GeoEntity {
    private Vec3 startPos;
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected AbstractMagicProjectile(EntityType<? extends ThrowableProjectile> type, Level world) {
        super(type, world);
    }

    protected AbstractMagicProjectile(EntityType<? extends ThrowableProjectile> type, Player shooter, Level world) {
        super(type, (LivingEntity)shooter, world);
        this.startPos = this.m_20182_();
    }

    public void m_8119_() {
        double distanceTraveled;
        super.m_8119_();
        if (this.startPos != null && (distanceTraveled = this.m_20182_().m_82554_(this.startPos)) > 16.0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity target = result.m_82443_();
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (!target.m_9236_().f_46443_) {
                PacketHandler.sendPacketToNearbyPlayers((ServerLevel)this.m_9236_(), this.m_20183_(), 28.0, new HitSpawnParticleToC(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0), this.getColorParticle()));
            }
            this.applyEffect(livingTarget);
            this.dealDamage(livingTarget);
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    protected abstract void applyEffect(LivingEntity var1);

    protected void dealDamage(LivingEntity target) {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            float spellPower = (float)player.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
            float damage = 2.0f + spellPower;
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)player), damage);
        }
    }

    abstract Vector3f getColorParticle();

    public boolean m_6000_(double pX, double pY, double pZ) {
        Level level = this.m_9236_();
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if (this.getColorParticle() != null) {
                ParticleBuilder particleBuilder = new ParticleBuilder(1).setColor(this.getColorParticle());
                for (int i = 0; i < 3; ++i) {
                    particleBuilder.spawnParticle(clientLevel, this.m_20185_(), this.m_20186_(), this.m_20189_());
                }
            }
        }
        return super.m_6000_(pX, pY, pZ);
    }

    protected void m_8097_() {
    }

    public void m_7378_(CompoundTag tag) {
    }

    public void m_7380_(CompoundTag tag) {
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> PlayState.STOP)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    protected float m_7139_() {
        return 0.0f;
    }
}

