/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import ru.xewe.immortal.entity.ClockworkArea;
import ru.xewe.immortal.entity.CustomLightningBolt;
import ru.xewe.immortal.entity.ElderWizardBookSoul;
import ru.xewe.immortal.entity.FireSoulEntity;
import ru.xewe.immortal.entity.GearEntity;
import ru.xewe.immortal.entity.IceSoulEntity;
import ru.xewe.immortal.entity.NatureSoulEntity;
import ru.xewe.immortal.entity.TransformedAuraEntity;
import ru.xewe.immortal.entity.projectiles.FireProjectile;
import ru.xewe.immortal.entity.projectiles.IceProjectile;
import ru.xewe.immortal.entity.projectiles.NatureProjectile;

public class RegisterManagerMobs {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"immortalskills");
    public static final RegistryObject<EntityType<FireSoulEntity>> FIRE_SOUL = RegisterManagerMobs.registerMob("fire_soul", FireSoulEntity::new, 0.15f, 0.15f);
    public static final RegistryObject<EntityType<IceSoulEntity>> ICE_SOUL;
    public static final RegistryObject<EntityType<NatureSoulEntity>> NATURE_SOUL;
    public static final RegistryObject<EntityType<ElderWizardBookSoul>> ELDER_WIZARD_BOOK_SOUL;
    public static final RegistryObject<EntityType<TransformedAuraEntity>> TRANSFORMED_AURA;
    public static final RegistryObject<EntityType<GearEntity>> GEAR_ENTITY;
    public static final RegistryObject<EntityType<FireProjectile>> FIRE_PROJECTILE;
    public static final RegistryObject<EntityType<IceProjectile>> ICE_PROJECTILE;
    public static final RegistryObject<EntityType<NatureProjectile>> NATURE_PROJECTILE;
    public static final RegistryObject<EntityType<CustomLightningBolt>> CUSTOM_LIGHTNING_BOLT;
    public static final RegistryObject<EntityType<ClockworkArea>> CLOCKWORK_AREA;

    public static <T extends Entity> RegistryObject<EntityType<T>> registerMob(String name, EntityType.EntityFactory<T> entity, float width, float height) {
        return ENTITIES.register(name, () -> EntityType.Builder.m_20704_((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).m_20699_(width, height).m_20712_(name));
    }

    public static void register(IEventBus bus) {
        ENTITIES.register(bus);
    }

    static {
        NATURE_SOUL = RegisterManagerMobs.registerMob("nature_soul", NatureSoulEntity::new, 0.15f, 0.15f);
        ICE_SOUL = RegisterManagerMobs.registerMob("ice_soul", IceSoulEntity::new, 0.15f, 0.15f);
        ELDER_WIZARD_BOOK_SOUL = RegisterManagerMobs.registerMob("elder_wizard_soul", ElderWizardBookSoul::new, 0.9f, 0.5f);
        FIRE_PROJECTILE = RegisterManagerMobs.registerMob("fire_projectile", FireProjectile::new, 0.15f, 0.15f);
        ICE_PROJECTILE = RegisterManagerMobs.registerMob("ice_projectile", IceProjectile::new, 0.15f, 0.15f);
        NATURE_PROJECTILE = RegisterManagerMobs.registerMob("nature_projectile", NatureProjectile::new, 0.15f, 0.15f);
        GEAR_ENTITY = RegisterManagerMobs.registerMob("gear", GearEntity::new, 0.4f, 0.4f);
        TRANSFORMED_AURA = RegisterManagerMobs.registerMob("block_aura", TransformedAuraEntity::new, 0.1f, 0.1f);
        CUSTOM_LIGHTNING_BOLT = RegisterManagerMobs.registerMob("custom_lightning_bolt", CustomLightningBolt::new, 0.5f, 0.5f);
        CLOCKWORK_AREA = RegisterManagerMobs.registerMob("clockwork_area", ClockworkArea::new, 6.0f, 0.3f);
    }
}

