/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.effect;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;
import ru.xewe.immortal.Config;
import ru.xewe.immortal.effect.ModEffect;
import ru.xewe.immortal.effect.RegisterManagerEffects;

public class UnholyAreaEffect
extends ModEffect {
    private BlockPos pos;
    private int radius;

    public UnholyAreaEffect() {
        super(MobEffectCategory.HARMFUL, 0xFFFFFF);
    }

    @Override
    public void m_6742_(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.radius = Config.UnholyKnightArmorAreaRadius;
            if (this.pos == null) {
                this.pos = player.m_20183_();
            }
            if (!entity.m_9236_().f_46443_) {
                AABB area = new AABB(this.pos).m_82400_((double)this.radius);
                List entities = entity.m_9236_().m_45976_(LivingEntity.class, area);
                for (LivingEntity target : entities) {
                    if (target == entity || target instanceof Player) continue;
                    if (!target.m_21023_(MobEffects.f_19615_)) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 260, 0));
                    }
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 260, 0));
                }
            } else {
                for (int i = 0; i < this.radius * 10; ++i) {
                    entity.m_9236_().m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f), 0.6f), (double)this.pos.m_123341_() + Math.random() * (double)(this.radius * 2) - (double)this.radius, (double)this.pos.m_123342_(), (double)this.pos.m_123343_() + Math.random() * (double)(this.radius * 2) - (double)this.radius, 0.0, 0.1, 0.0);
                }
                this.createParticleRing(player.m_9236_(), this.pos.m_123341_(), this.pos.m_123342_(), this.pos.m_123343_(), this.radius);
            }
        }
    }

    private void createParticleRing(Level level, double x, double y, double z, int radius) {
        int particleCount = 18 * radius;
        double angleIncrement = Math.PI * 2 / (double)particleCount;
        for (int i = 0; i < particleCount; ++i) {
            double angle = (double)i * angleIncrement;
            double px = x + (double)radius * Math.cos(angle);
            double pz = z + (double)radius * Math.sin(angle);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, px, y, pz, 0.0, 0.1, 0.0);
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        if (duration == 1) {
            this.pos = null;
            return false;
        }
        return true;
    }

    @Override
    ModEffect getEffect() {
        return (ModEffect)((Object)RegisterManagerEffects.UNHOLY_EFFECT.get());
    }
}

