/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.client.renderer.effect;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import ru.xewe.immortal.effect.RegisterManagerEffects;

@Mod.EventBusSubscriber(modid="immortalskills", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderLivingEntity {
    private static final ResourceLocation INQUISITOR_MARK = new ResourceLocation("immortalskills", "textures/gui/inquisitor_mark_icon.png");
    private static final ResourceLocation TIME_MARK = new ResourceLocation("immortalskills", "textures/gui/time_mark.png");

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
        Vec3 cameraPos = mc.f_91063_.m_109153_().m_90583_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (Entity entity : mc.f_91073_.m_104735_()) {
            MobEffectInstance effect;
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_21023_((MobEffect)RegisterManagerEffects.INQUISITOR_MARK_EFFECT.get()) && (effect = livingEntity.m_21124_((MobEffect)RegisterManagerEffects.INQUISITOR_MARK_EFFECT.get())) != null && effect.m_19557_() > 0) {
                RenderLivingEntity.renderBillboardIcon(poseStack, (MultiBufferSource)bufferSource, entity, cameraPos, INQUISITOR_MARK, 0.5f, 0.5f);
            }
            if (!livingEntity.m_21023_((MobEffect)RegisterManagerEffects.TIME_MARK_EFFECT.get()) || (effect = livingEntity.m_21124_((MobEffect)RegisterManagerEffects.TIME_MARK_EFFECT.get())) == null || effect.m_19557_() <= 0) continue;
            RenderLivingEntity.renderBillboardIcon(poseStack, (MultiBufferSource)bufferSource, entity, cameraPos, TIME_MARK, 0.5f, 0.5f);
        }
        bufferSource.m_109911_();
        RenderSystem.disableBlend();
    }

    private static void renderBillboardIcon(PoseStack poseStack, MultiBufferSource bufferSource, Entity entity, Vec3 cameraPos, ResourceLocation texture, float size, float heightOffset) {
        poseStack.m_85836_();
        Vec3 pos = entity.m_20318_(Minecraft.m_91087_().m_91296_()).m_82520_(0.0, (double)(entity.m_20206_() + heightOffset), 0.0);
        poseStack.m_85837_(pos.f_82479_ - cameraPos.f_82479_, pos.f_82480_ - cameraPos.f_82480_, pos.f_82481_ - cameraPos.f_82481_);
        poseStack.m_252781_(Minecraft.m_91087_().m_91290_().f_114358_.m_253121_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)texture));
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        Matrix3f normal = poseStack.m_85850_().m_252943_();
        float halfSize = size / 2.0f;
        consumer.m_252986_(pose, -halfSize, halfSize, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, halfSize, halfSize, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, halfSize, -halfSize, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        consumer.m_252986_(pose, -halfSize, -halfSize, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        poseStack.m_85849_();
    }
}

