/*
 * Decompiled with CFR 0.152.
 */
package ru.xewe.immortal.blocks.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.xewe.immortal.blocks.RegisterManagerBlocks;
import ru.xewe.immortal.blocks.blockentity.AltarBlockTile;

public class AltarBlock
extends BaseEntityBlock {
    public static final List<BlockPos> GEM_BLOCK_OFFSETS = BlockPos.m_121886_((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(blockPos -> Math.abs(blockPos.m_123341_()) == 2 || Math.abs(blockPos.m_123343_()) == 2).map(BlockPos::m_7949_).toList();
    public static final VoxelShape SHAPE_COLUMN_1 = Block.m_49796_((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0);
    public static final VoxelShape SHAPE_COLUMN_2 = Block.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)19.0, (double)14.0);
    public static final VoxelShape SHAPE_COLUMN_3 = Block.m_49796_((double)3.0, (double)19.0, (double)3.0, (double)13.0, (double)21.0, (double)13.0);
    public static final VoxelShape SHAPE_BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)SHAPE_COLUMN_1, (VoxelShape[])new VoxelShape[]{SHAPE_COLUMN_2, SHAPE_COLUMN_3, SHAPE_BOTTOM});
    private static final int CHECK_RADIUS = 2;
    private static final List<Block> BOOSTER_BLOCKS = List.of();

    public AltarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283927_).m_60999_().m_60913_(3.0f, 1200.0f));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new AltarBlockTile(pPos, pState);
    }

    public void m_6810_(BlockState pState, Level level, BlockPos pos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.m_60734_() != pNewState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof AltarBlockTile) {
            AltarBlockTile altarEntity = (AltarBlockTile)blockEntity;
            altarEntity.drops();
        }
        super.m_6810_(pState, level, pos, pNewState, pIsMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.m_5776_()) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof AltarBlockTile) {
                AltarBlockTile altarEntity = (AltarBlockTile)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)altarEntity, (BlockPos)blockPos);
                return InteractionResult.CONSUME;
            }
            throw new IllegalStateException("Our container provider is missing");
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        return AltarBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)RegisterManagerBlocks.ALTAR_BLOCK_TILE.get()), (pLevel1, pos, state1, tileEntity) -> tileEntity.tick(pLevel1, pos, state1, (AltarBlockTile)tileEntity));
    }

    public static int countNearbyGemBlocks(Level level, BlockPos pos) {
        int count = 0;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    mutablePos.m_122190_((Vec3i)pos).m_122184_(x, y, z);
                    Block block = level.m_8055_((BlockPos)mutablePos).m_60734_();
                    if (!BOOSTER_BLOCKS.contains(block)) continue;
                    ++count;
                }
            }
        }
        return Math.min(count, 9);
    }
}

