/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.util;

import java.util.function.Consumer;

public class EventableTimer {
    public static final int NONE_ANIMATION = -1;
    public int ticks = 0;
    public int ticksDuration = 0;
    public int currentAnimationState = -1;
    private Consumer<Integer> runnableEndAnimation = animationState -> {};
    private Consumer<Integer> runnableStartAnimation = animationState -> {};

    public EventableTimer(Consumer<Integer> runnableEndAnimation) {
        this.runnableEndAnimation = runnableEndAnimation;
    }

    public EventableTimer onStartAnimation(Consumer<Integer> runnableStartAnimation) {
        this.setOnStartAnimation(runnableStartAnimation);
        return this;
    }

    public EventableTimer onEndAnimation(Consumer<Integer> runnableEndAnimation) {
        this.setOnEndAnimation(runnableEndAnimation);
        return this;
    }

    public void setOnStartAnimation(Consumer<Integer> runnableStartAnimation) {
        this.runnableStartAnimation = runnableStartAnimation;
    }

    public void setOnEndAnimation(Consumer<Integer> runnableEndAnimation) {
        this.runnableEndAnimation = runnableEndAnimation;
    }

    public void startAnimation(int animationState, int ticksDuration) {
        if (this.currentAnimationState == -1) {
            this.runnableStartAnimation.accept(animationState);
            this.currentAnimationState = animationState;
            this.ticksDuration = ticksDuration;
            this.ticks = 0;
        } else {
            System.err.println("Can't start animation because " + this.currentAnimationState + " is running!");
        }
    }

    public void update() {
        if (this.isPlaying(this.currentAnimationState)) {
            this.ticks = Math.min(this.ticks + 1, this.ticksDuration);
            if (this.ticks >= this.ticksDuration) {
                this.endAnimation();
            }
        }
    }

    private void endAnimation() {
        int animationEnded = this.currentAnimationState;
        this.currentAnimationState = -1;
        this.ticksDuration = 0;
        this.ticks = -1;
        this.runnableEndAnimation.accept(animationEnded);
    }

    public boolean isPlaying() {
        return this.currentAnimationState != -1 & this.ticks > -1 & this.ticksDuration > 0;
    }

    public boolean isPlaying(int animationState) {
        return this.isPlaying() & this.currentAnimationState == animationState;
    }

    public int getDurationTicks() {
        return this.isPlaying() ? this.ticksDuration : -1;
    }

    public int getCurrentTicks() {
        return this.ticks;
    }

    public void forceStop() {
        this.currentAnimationState = -1;
        this.ticksDuration = 0;
        this.ticks = 0;
    }
}

