/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.spawner;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.ForgeEventFactory;
import net.moddercoder.immortalgingerbread.entity.ModEntityTypes;
import net.moddercoder.immortalgingerbread.entity.SpoiledSnowmanEntity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/moddercoder/immortalgingerbread/spawner/SpoiledPatrolSpawner;", "Lnet/minecraft/world/level/CustomSpawner;", "()V", "nextTick", "", "spawnPatrolMember", "", "serverWorld", "Lnet/minecraft/server/level/ServerLevel;", "blockPos", "Lnet/minecraft/core/BlockPos;", "patrolLeader", "tick", "spawnEnemies", "spawnFriendlies", "immortalgingerbread-1.20.1"})
public final class SpoiledPatrolSpawner
implements CustomSpawner {
    private int nextTick;

    public int m_7995_(@NotNull ServerLevel serverWorld, boolean spawnEnemies, boolean spawnFriendlies) {
        boolean midnight;
        Intrinsics.checkNotNullParameter((Object)serverWorld, (String)"serverWorld");
        if (!spawnEnemies) {
            return 0;
        }
        if (!serverWorld.m_46469_().m_46207_(GameRules.f_46124_)) {
            return 0;
        }
        RandomSource randomSource = serverWorld.f_46441_;
        this.nextTick += -1;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += 6000 + randomSource.m_188503_(1200);
        long dayTime = serverWorld.m_46468_() % 24000L;
        boolean bl = 18000L <= dayTime ? dayTime < 24000L : (midnight = false);
        if (midnight) {
            int randValue = randomSource.m_188503_(5);
            if (randValue != 0) {
                return 0;
            }
            int playersCount = serverWorld.m_6907_().size();
            if (playersCount < 1) {
                return 0;
            }
            ServerPlayer serverPlayer = serverWorld.m_8890_();
            if (serverPlayer == null) {
                return 0;
            }
            ServerPlayer player = serverPlayer;
            if (player.m_5833_()) {
                return 0;
            }
            if (serverWorld.m_8736_(player.m_20183_(), 2)) {
                return 0;
            }
            int k = (24 + randomSource.m_188503_(24)) * (randomSource.m_188499_() ? -1 : 1);
            int l = (24 + randomSource.m_188503_(24)) * (randomSource.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos spawnCenterBlockPos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
            if (!serverWorld.m_151572_(spawnCenterBlockPos.m_123341_() - 10, spawnCenterBlockPos.m_123343_() - 10, spawnCenterBlockPos.m_123341_() + 10, spawnCenterBlockPos.m_123343_() + 10)) {
                return 0;
            }
            Holder holder = serverWorld.m_204166_((BlockPos)spawnCenterBlockPos);
            if (holder.m_203656_(BiomeTags.f_215806_)) {
                return 0;
            }
            int j1 = 0;
            int k1 = (int)Math.ceil(serverWorld.m_6436_((BlockPos)spawnCenterBlockPos).m_19056_()) + 1;
            for (int l1 = 0; l1 < k1; ++l1) {
                ++j1;
                spawnCenterBlockPos.m_142448_(serverWorld.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)spawnCenterBlockPos).m_123342_());
                if (l1 == 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)spawnCenterBlockPos, (String)"spawnCenterBlockPos");
                    if (!this.spawnPatrolMember(serverWorld, (BlockPos)spawnCenterBlockPos, true)) {
                        break;
                    }
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)spawnCenterBlockPos, (String)"spawnCenterBlockPos");
                    this.spawnPatrolMember(serverWorld, (BlockPos)spawnCenterBlockPos, false);
                }
                spawnCenterBlockPos.m_142451_(spawnCenterBlockPos.m_123341_() + randomSource.m_188503_(5) - randomSource.m_188503_(5));
                spawnCenterBlockPos.m_142443_(spawnCenterBlockPos.m_123343_() + randomSource.m_188503_(5) - randomSource.m_188503_(5));
            }
            Object[] objectArray = new Object[]{spawnCenterBlockPos.m_123344_()};
            player.m_213846_((Component)Component.m_237110_((String)"text.spoiled_patrol_spawned", (Object[])objectArray));
            return j1;
        }
        return 0;
    }

    private final boolean spawnPatrolMember(ServerLevel serverWorld, BlockPos blockPos, boolean patrolLeader) {
        BlockState blockState = serverWorld.m_8055_(blockPos);
        if (!NaturalSpawner.m_47056_((BlockGetter)((BlockGetter)serverWorld), (BlockPos)blockPos, (BlockState)blockState, (FluidState)blockState.m_60819_(), (EntityType)((EntityType)ModEntityTypes.INSTANCE.getSPOILED_SNOWMAN().get()))) {
            return false;
        }
        SpoiledSnowmanEntity patrollingMonster = (SpoiledSnowmanEntity)((EntityType)ModEntityTypes.INSTANCE.getSPOILED_SNOWMAN().get()).m_20615_((Level)serverWorld);
        if (patrollingMonster != null) {
            patrollingMonster.setPatrolLeader(patrolLeader);
            patrollingMonster.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            ForgeEventFactory.onFinalizeSpawn((Mob)((Mob)patrollingMonster), (ServerLevelAccessor)((ServerLevelAccessor)serverWorld), (DifficultyInstance)serverWorld.m_6436_(blockPos), (MobSpawnType)MobSpawnType.PATROL, null, null);
            serverWorld.m_47205_((Entity)patrollingMonster);
            return true;
        }
        return false;
    }
}

