/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.raid;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.moddercoder.immortalgingerbread.effect.ModMobEffects;
import net.moddercoder.immortalgingerbread.entity.AbstractSpoiledPatrolEntity;
import net.moddercoder.immortalgingerbread.entity.raid.SpoiledRaid;
import net.moddercoder.immortalgingerbread.mixinexpander.IServerLevelExpander;

public class SpoiledRaids
extends SavedData {
    private static final String RAID_FILE_ID = "raids";
    private final Map<Integer, SpoiledRaid> raidMap = Maps.newHashMap();
    private final ServerLevel level;
    private int nextAvailableID;
    private int tick;

    public SpoiledRaids(ServerLevel p_37956_) {
        this.level = p_37956_;
        this.nextAvailableID = 1;
        this.m_77762_();
    }

    public SpoiledRaid get(int p_37959_) {
        return this.raidMap.get(p_37959_);
    }

    public void tick() {
        ++this.tick;
        Iterator<SpoiledRaid> iterator = this.raidMap.values().iterator();
        while (iterator.hasNext()) {
            SpoiledRaid raid = iterator.next();
            if (this.level.m_46469_().m_46207_(GameRules.f_46154_)) {
                raid.stop();
            }
            if (raid.isStopped()) {
                iterator.remove();
                this.m_77762_();
                continue;
            }
            raid.tick();
        }
        if (this.tick % 200 == 0) {
            this.m_77762_();
        }
    }

    public static boolean canJoinRaid(AbstractSpoiledPatrolEntity p_37966_, SpoiledRaid p_37967_) {
        if (p_37966_ != null && p_37967_ != null && p_37967_.getLevel() != null) {
            return p_37966_.m_6084_() && p_37966_.canJoinRaid() && p_37966_.m_21216_() <= 2400 && p_37966_.m_9236_().m_6042_() == p_37967_.getLevel().m_6042_();
        }
        return false;
    }

    @Nullable
    public SpoiledRaid createOrExtendRaid(ServerPlayer p_37964_) {
        BlockPos blockpos1;
        if (p_37964_.m_5833_()) {
            return null;
        }
        if (this.level.m_46469_().m_46207_(GameRules.f_46154_)) {
            return null;
        }
        DimensionType dimensiontype = p_37964_.m_9236_().m_6042_();
        if (!dimensiontype.m_63963_()) {
            return null;
        }
        BlockPos blockpos = p_37964_.m_20183_();
        List list = this.level.m_8904_().m_27181_(p_219845_ -> p_219845_.m_203656_(PoiTypeTags.f_215876_), blockpos, 64, PoiManager.Occupancy.IS_OCCUPIED).toList();
        int i = 0;
        Vec3 vec3 = Vec3.f_82478_;
        for (PoiRecord poirecord : list) {
            BlockPos blockpos2 = poirecord.m_27257_();
            vec3 = vec3.m_82520_((double)blockpos2.m_123341_(), (double)blockpos2.m_123342_(), (double)blockpos2.m_123343_());
            ++i;
        }
        if (i > 0) {
            vec3 = vec3.m_82490_(1.0 / (double)i);
            blockpos1 = BlockPos.m_274446_((Position)vec3);
        } else {
            blockpos1 = blockpos;
        }
        SpoiledRaid raid = this.getOrCreateRaid(p_37964_.m_284548_(), blockpos1);
        boolean flag = false;
        if (!raid.isStarted()) {
            if (!this.raidMap.containsKey(raid.getId())) {
                this.raidMap.put(raid.getId(), raid);
            }
            flag = true;
        } else if (raid.getBadOmenLevel() < raid.getMaxBadOmenLevel()) {
            flag = true;
        } else {
            p_37964_.m_21195_((MobEffect)ModMobEffects.INSTANCE.getSUGAR_RUSH().get());
            p_37964_.f_8906_.m_9829_((Packet)new ClientboundEntityEventPacket((Entity)p_37964_, 43));
        }
        if (flag) {
            raid.absorbBadOmen((Player)p_37964_);
            p_37964_.f_8906_.m_9829_((Packet)new ClientboundEntityEventPacket((Entity)p_37964_, 43));
            if (!raid.hasFirstWaveSpawned()) {
                p_37964_.m_36220_(Stats.f_12980_);
            }
        }
        this.m_77762_();
        return raid;
    }

    private SpoiledRaid getOrCreateRaid(ServerLevel p_37961_, BlockPos p_37962_) {
        SpoiledRaid raid = ((IServerLevelExpander)p_37961_).getSpoiledRaidAt(p_37962_);
        return raid != null ? raid : new SpoiledRaid(this.getUniqueId(), p_37961_, p_37962_);
    }

    public static SpoiledRaids load(ServerLevel p_150236_, CompoundTag p_150237_) {
        SpoiledRaids raids = new SpoiledRaids(p_150236_);
        raids.nextAvailableID = p_150237_.m_128451_("NextAvailableID");
        raids.tick = p_150237_.m_128451_("Tick");
        ListTag listtag = p_150237_.m_128437_("Raids", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            SpoiledRaid raid = new SpoiledRaid(p_150236_, compoundtag);
            raids.raidMap.put(raid.getId(), raid);
        }
        return raids;
    }

    public CompoundTag m_7176_(CompoundTag p_37976_) {
        p_37976_.m_128405_("NextAvailableID", this.nextAvailableID);
        p_37976_.m_128405_("Tick", this.tick);
        ListTag listtag = new ListTag();
        for (SpoiledRaid raid : this.raidMap.values()) {
            CompoundTag compoundtag = new CompoundTag();
            raid.save(compoundtag);
            listtag.add((Object)compoundtag);
        }
        p_37976_.m_128365_("Raids", (Tag)listtag);
        return p_37976_;
    }

    public static String getFileId(Holder<DimensionType> p_211597_) {
        return p_211597_.m_203565_(BuiltinDimensionTypes.f_223540_) ? "spoiled_raids_end" : "spoiled_raids";
    }

    private int getUniqueId() {
        return ++this.nextAvailableID;
    }

    @Nullable
    public SpoiledRaid getNearbyRaid(BlockPos playerBlockPos, int maxRaidDistance) {
        for (SpoiledRaid spoiledRaid : this.raidMap.values()) {
            double d1 = spoiledRaid.getCenter().m_123331_((Vec3i)playerBlockPos);
            if (!spoiledRaid.isActive() || !(d1 < (double)maxRaidDistance)) continue;
            return spoiledRaid;
        }
        return null;
    }
}

