/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.phys.Vec3;
import net.moddercoder.immortalgingerbread.entity.AbstractSpoiledPatrolEntity;

public class SpoiledRaiderMoveThroughVillageGoal
extends Goal {
    private final AbstractSpoiledPatrolEntity raider;
    private final double speedModifier;
    private BlockPos poiPos;
    private final List<BlockPos> visited = Lists.newArrayList();
    private final int distanceToPoi;
    private boolean stuck;

    public SpoiledRaiderMoveThroughVillageGoal(AbstractSpoiledPatrolEntity p_37936_, double p_37937_, int p_37938_) {
        this.raider = p_37936_;
        this.speedModifier = p_37937_;
        this.distanceToPoi = p_37938_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        this.updateVisited();
        return this.isValidRaid() && this.hasSuitablePoi() && this.raider.m_5448_() == null;
    }

    private boolean isValidRaid() {
        return this.raider.hasActiveRaid() && !this.raider.getCurrentRaid().isOver();
    }

    private boolean hasSuitablePoi() {
        ServerLevel serverlevel = (ServerLevel)this.raider.m_9236_();
        BlockPos blockpos = this.raider.m_20183_();
        Optional optional = serverlevel.m_8904_().m_217951_(p_219843_ -> p_219843_.m_203565_(PoiTypes.f_218060_), this::hasNotVisited, PoiManager.Occupancy.ANY, blockpos, 48, this.raider.m_217043_());
        if (!optional.isPresent()) {
            return false;
        }
        this.poiPos = ((BlockPos)optional.get()).m_7949_();
        return true;
    }

    public boolean m_8045_() {
        if (this.raider.m_21573_().m_26571_()) {
            return false;
        }
        return this.raider.m_5448_() == null && !this.poiPos.m_203195_((Position)this.raider.m_20182_(), (double)(this.raider.m_20205_() + (float)this.distanceToPoi)) && !this.stuck;
    }

    public void m_8041_() {
        if (this.poiPos.m_203195_((Position)this.raider.m_20182_(), (double)this.distanceToPoi)) {
            this.visited.add(this.poiPos);
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.raider.m_21310_(0);
        this.raider.m_21573_().m_26519_((double)this.poiPos.m_123341_(), (double)this.poiPos.m_123342_(), (double)this.poiPos.m_123343_(), this.speedModifier);
        this.stuck = false;
    }

    public void m_8037_() {
        if (this.raider.m_21573_().m_26571_()) {
            Vec3 vec3 = Vec3.m_82539_((Vec3i)this.poiPos);
            Vec3 vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.raider, (int)16, (int)7, (Vec3)vec3, (double)0.3141592741012573);
            if (vec31 == null) {
                vec31 = DefaultRandomPos.m_148412_((PathfinderMob)this.raider, (int)8, (int)7, (Vec3)vec3, (double)1.5707963705062866);
            }
            if (vec31 == null) {
                this.stuck = true;
                return;
            }
            this.raider.m_21573_().m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
        }
    }

    private boolean hasNotVisited(BlockPos p_37943_) {
        for (BlockPos blockpos : this.visited) {
            if (!Objects.equals(p_37943_, blockpos)) continue;
            return false;
        }
        return true;
    }

    private void updateVisited() {
        if (this.visited.size() > 2) {
            this.visited.remove(0);
        }
    }
}

