/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.BiFunction;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.moddercoder.immortalgingerbread.entity.IAttackAnimatable;
import net.moddercoder.immortalgingerbread.util.EventableTimer;

public class AnimatedRangedAttackGoal<T extends PathfinderMob & IAttackAnimatable>
extends Goal {
    private static final int ANIMATION_RANGE_ATTACK = 0;
    protected final T mob;
    protected final Level world;
    protected double speedModifier;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    protected int ticksUntilNextPathRecalculation;
    protected final int animationDurationSkillBeforeUsing;
    protected final int animationDurationSkillAfterUsing;
    protected final EventableTimer eventableTimer = new EventableTimer(this::onAnimationEnded).onStartAnimation(this::onAnimatedStarted);
    private BiFunction<T, LivingEntity, Double> functionReachDistance = (entityPet, entityTarget) -> entityPet.m_20205_() * 16.0f + entityTarget.m_20205_();

    public AnimatedRangedAttackGoal(T mob, double speedModifier, int animationDurationSkillBeforeUsing, int animationDurationSkillAfterUsing) {
        this.mob = mob;
        this.world = this.mob.m_9236_();
        this.speedModifier = speedModifier;
        this.animationDurationSkillBeforeUsing = animationDurationSkillBeforeUsing;
        this.animationDurationSkillAfterUsing = animationDurationSkillAfterUsing;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            return false;
        }
        if (this.eventableTimer.isPlaying()) {
            return false;
        }
        return this.getSquaredReachDistance(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
        this.mob.m_21573_().m_26573_();
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.eventableTimer.forceStop();
    }

    public boolean m_8045_() {
        Player targetPlayer;
        if (this.eventableTimer.isPlaying()) {
            return true;
        }
        LivingEntity targetEntity = this.mob.m_5448_();
        if (targetEntity == null) {
            return false;
        }
        if (!targetEntity.m_6084_()) {
            return false;
        }
        if (!this.mob.m_21444_(targetEntity.m_20183_())) {
            return false;
        }
        return !(targetEntity instanceof Player) || !(targetPlayer = (Player)targetEntity).m_5833_() && !targetPlayer.m_7500_();
    }

    public void m_8037_() {
        this.eventableTimer.update();
        LivingEntity entityTarget = this.mob.m_5448_();
        if (entityTarget == null) {
            return;
        }
        if (!this.eventableTimer.isPlaying()) {
            if (!this.canSee(entityTarget)) {
                this.mob.m_21563_().m_24960_((Entity)entityTarget, 30.0f, 30.0f);
                this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                if (this.ticksUntilNextPathRecalculation == 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || entityTarget.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                    this.pathedTargetX = entityTarget.m_20185_();
                    this.pathedTargetY = entityTarget.m_20186_();
                    this.pathedTargetZ = entityTarget.m_20189_();
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    if (!this.mob.m_21573_().m_5624_((Entity)entityTarget, this.speedModifier)) {
                        this.ticksUntilNextPathRecalculation += 15;
                    }
                    this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                }
            } else if (this.canSee(entityTarget)) {
                this.startAnimationLogic();
                ((IAttackAnimatable)this.mob).playAttackAnimation();
            }
        } else {
            int ticks = this.eventableTimer.getCurrentTicks();
            int ticksDuration = this.eventableTimer.getDurationTicks();
            ((IAttackAnimatable)this.mob).tickAttackAnimation(ticks, ticksDuration);
            if (ticks == this.animationDurationSkillBeforeUsing) {
                ((RangedAttackMob)this.mob).m_6504_(entityTarget, 1.0f);
            }
        }
    }

    protected void startAnimationLogic() {
        this.eventableTimer.startAnimation(0, this.animationDurationSkillBeforeUsing + this.animationDurationSkillAfterUsing);
    }

    private void onAnimatedStarted(int animationState) {
        switch (animationState) {
            case 0: {
                LivingEntity entityTarget = this.mob.m_5448_();
                if (entityTarget != null && entityTarget.m_6084_()) {
                    this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, entityTarget.m_20182_());
                }
                this.mob.m_21573_().m_26573_();
            }
        }
    }

    private void onAnimationEnded(int animationState) {
        switch (animationState) {
            case 0: {
                this.mob.m_21561_(false);
            }
        }
    }

    protected boolean canSee(LivingEntity entityTarget) {
        Vec3 targetPos;
        if (this.mob.m_9236_() != entityTarget.m_9236_()) {
            return false;
        }
        if (this.mob.m_20182_().m_82557_(entityTarget.m_20182_()) > this.getSquaredReachDistance(entityTarget)) {
            return false;
        }
        Vec3 selfPos = this.mob.m_20182_().m_82520_(0.0, (double)(this.mob.m_20206_() / 2.0f), 0.0);
        return this.world.m_45547_(new ClipContext(selfPos, targetPos = entityTarget.m_20182_().m_82520_(0.0, (double)(entityTarget.m_20206_() / 2.0f), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this.mob)).m_6662_() == HitResult.Type.MISS;
    }

    public AnimatedRangedAttackGoal<T> reachDistance(BiFunction<T, LivingEntity, Double> functionReachDistance) {
        this.functionReachDistance = functionReachDistance;
        return this;
    }

    protected double getSquaredReachDistance(LivingEntity entity) {
        return Math.pow(this.getReachDistance(entity), 2.0);
    }

    protected double getReachDistance(LivingEntity entity) {
        return this.functionReachDistance.apply(this.mob, entity);
    }

    public boolean isAnyAnimationPlaying() {
        return this.eventableTimer.isPlaying();
    }

    public boolean m_183429_() {
        return true;
    }
}

