/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.BiFunction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.moddercoder.immortalgingerbread.entity.IAttackAnimatable;

public class AnimatedMeleeAttackGoal<T extends PathfinderMob>
extends Goal {
    protected final T mob;
    protected final double speedModifier;
    private Path path;
    private double targetX;
    private double targetY;
    private double targetZ;
    protected int updateCountdownTicks;
    private long lastUpdateTime;
    protected Level world;
    protected int attackCooldownTicks = 0;
    protected int animationTicksValue = 0;
    protected boolean animationPlaying = false;
    protected boolean animationCooldown = false;
    protected final int animationDurationTicks;
    protected final int attackCooldownDuration;
    protected final int animationDurationTicksAfterDamage;
    protected final int animationDurationTicksBeforeDamage;
    private BiFunction<T, LivingEntity, Double> functionReachDistance = (entityPet, entityTarget) -> entityPet.m_20205_() * 4.0f + entityTarget.m_20205_();

    public AnimatedMeleeAttackGoal(T mob, double speedModifier, int animationDurationTicksBeforeDamage, int animationDurationTicksAfterDamage, int attackCooldownDuration) {
        this.mob = mob;
        this.world = this.mob.m_9236_();
        this.speedModifier = speedModifier;
        this.attackCooldownDuration = attackCooldownDuration;
        this.animationDurationTicksAfterDamage = animationDurationTicksAfterDamage;
        this.animationDurationTicksBeforeDamage = animationDurationTicksBeforeDamage;
        this.animationDurationTicks = animationDurationTicksAfterDamage + animationDurationTicksBeforeDamage;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.world.m_46467_();
        if (l - this.lastUpdateTime < (long)this.animationDurationTicks) {
            return false;
        }
        if (!this.canStartAttack()) {
            return false;
        }
        this.lastUpdateTime = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getSquaredReachDistance(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
        this.mob.m_21573_().m_26536_(this.path, this.speedModifier);
        this.attackCooldownTicks = 0;
        this.updateCountdownTicks = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.stopAttacking();
        this.mob.m_21561_(false);
        this.stopAttackingCooldown();
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return;
        }
        this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
        double d = this.mob.m_262793_(livingEntity);
        this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
        if (!this.isAttackCoolingdown()) {
            if (this.animationCooldown) {
                if (this.animationTicksValue <= 0) {
                    this.stopAttackingCooldown();
                } else {
                    this.animationTicksValue = Math.max(this.animationTicksValue - 1, 0);
                }
            } else if (this.animationPlaying) {
                if (this.animationTicksValue <= 0) {
                    this.attack(livingEntity, d);
                    this.startAttackingCooldown();
                } else {
                    this.animationTicksValue = Math.max(this.animationTicksValue - 1, 0);
                }
            }
        } else {
            --this.attackCooldownTicks;
        }
        if (this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
            this.targetX = livingEntity.m_20185_();
            this.targetY = livingEntity.m_20186_();
            this.targetZ = livingEntity.m_20189_();
            this.updateCountdownTicks = 4 + this.mob.m_217043_().m_188503_(7);
            if (d > 1024.0) {
                this.updateCountdownTicks += 10;
            } else if (d > 256.0) {
                this.updateCountdownTicks += 5;
            }
            if (!this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speedModifier)) {
                this.updateCountdownTicks += 15;
            }
            this.updateCountdownTicks = this.m_183277_(this.updateCountdownTicks);
        }
        if (!this.isAttackCoolingdown() && this.canStartAttack() && this.canAttack(livingEntity, d)) {
            this.startAttackingFlags();
            this.startAttacking();
        }
    }

    protected void startAttacking() {
        ((IAttackAnimatable)this.mob).playAttackAnimation();
    }

    protected void startAttackingFlags() {
        this.animationPlaying = true;
        this.animationTicksValue = this.animationDurationTicksBeforeDamage;
    }

    protected void stopAttacking() {
        this.animationPlaying = false;
    }

    protected void startAttackingCooldown() {
        this.animationCooldown = true;
        this.stopAttacking();
        this.animationTicksValue = this.animationDurationTicksBeforeDamage;
    }

    protected void stopAttackingCooldown() {
        this.animationCooldown = false;
    }

    protected boolean attack(LivingEntity target, double squaredDistance) {
        boolean canAttack = this.canAttack(target, squaredDistance);
        if (canAttack) {
            this.mob.m_6674_(InteractionHand.MAIN_HAND);
            this.mob.m_7327_((Entity)target);
            return true;
        }
        return false;
    }

    public AnimatedMeleeAttackGoal<T> reachDistance(BiFunction<T, LivingEntity, Double> functionReachDistance) {
        this.functionReachDistance = functionReachDistance;
        return this;
    }

    protected double getSquaredReachDistance(LivingEntity entity) {
        return Math.pow(this.getReachDistance(entity), 2.0);
    }

    protected double getReachDistance(LivingEntity entity) {
        return this.functionReachDistance.apply(this.mob, entity);
    }

    protected void startAttackCooldown() {
        this.attackCooldownTicks = this.attackCooldownDuration;
    }

    protected boolean isAttackCoolingdown() {
        return this.attackCooldownTicks > 0;
    }

    public boolean canStartAttack() {
        return !(this.animationPlaying | this.animationCooldown);
    }

    public boolean canAttack(LivingEntity target, double squaredDistance) {
        double d = this.getSquaredReachDistance(target);
        return squaredDistance <= d;
    }

    public boolean m_183429_() {
        return true;
    }
}

