/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.moddercoder.immortalgingerbread.entity.AbstractSnowmanEntity;
import net.moddercoder.immortalgingerbread.entity.IMeleeAttackAnimatable;
import net.moddercoder.immortalgingerbread.entity.IRangeAttackAnimatable;
import net.moddercoder.immortalgingerbread.entity.ISpoiledPatrolEntity;
import net.moddercoder.immortalgingerbread.entity.ai.goal.AnimatedMeleeAttackGoal;
import net.moddercoder.immortalgingerbread.entity.ai.goal.AnimatedRangedAttackGoal;
import net.moddercoder.immortalgingerbread.item.ModItems;
import net.moddercoder.immortalgingerbread.sound.ModSoundEvents;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 J2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001JB\u001d\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0018H\u0016J\b\u0010%\u001a\u00020!H\u0014J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J \u0010)\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0018H\u0014J\b\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020\fH\u0016J\b\u0010/\u001a\u000200H\u0014J \u00101\u001a\u00020!2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000203H\u0016J\u0018\u00106\u001a\u00020!2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000200H\u0016J\b\u0010:\u001a\u00020!H\u0016J\b\u0010;\u001a\u00020!H\u0016J\b\u0010<\u001a\u00020!H\u0016J\u0018\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0014J\u0010\u0010B\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010C\u001a\u00020!2\u0006\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020!H\u0014J\b\u0010G\u001a\u00020!H\u0002J\b\u0010H\u001a\u00020!H\u0016J\b\u0010I\u001a\u00020!H\u0014R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00000\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00000\u00000\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lnet/moddercoder/immortalgingerbread/entity/SpoiledSnowmanEntity;", "Lnet/moddercoder/immortalgingerbread/entity/AbstractSnowmanEntity;", "Lnet/moddercoder/immortalgingerbread/entity/ISpoiledPatrolEntity;", "Lnet/moddercoder/immortalgingerbread/entity/IRangeAttackAnimatable;", "Lnet/moddercoder/immortalgingerbread/entity/IMeleeAttackAnimatable;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "animatableInstanceCache", "Lsoftware/bernie/geckolib/core/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "meleeAttackGoal", "Lnet/moddercoder/immortalgingerbread/entity/ai/goal/AnimatedMeleeAttackGoal;", "movingTicks", "", "getMovingTicks", "()I", "setMovingTicks", "(I)V", "ourDeathTime", "value", "", "patrolLeader", "getPatrolLeader", "()Z", "setPatrolLeader", "(Z)V", "rangeAttackGoal", "Lnet/moddercoder/immortalgingerbread/entity/ai/goal/AnimatedRangedAttackGoal;", "addAdditionalSaveData", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "canBeHitByProjectile", "defineSynchedData", "die", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "dropCustomDeathLoot", "p_21386_", "alwaysDrop", "getAmbientSound", "Lnet/minecraft/sounds/SoundEvent;", "getAnimatableInstanceCache", "getSoundVolume", "", "knockback", "velX", "", "velY", "velZ", "performRangedAttack", "targetEntity", "Lnet/minecraft/world/entity/LivingEntity;", "strength", "playAttackAnimation", "playMeleeAttackAnimation", "playRangeAttackAnimation", "playStepSound", "blockPos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "readAdditionalSaveData", "registerControllers", "controllerRegistrar", "Lsoftware/bernie/geckolib/core/animation/AnimatableManager$ControllerRegistrar;", "registerGoals", "removeAllAttackGoals", "tick", "tickDeath", "Companion", "immortalgingerbread-1.20.1"})
public class SpoiledSnowmanEntity
extends AbstractSnowmanEntity
implements ISpoiledPatrolEntity,
IRangeAttackAnimatable,
IMeleeAttackAnimatable,
GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimatedRangedAttackGoal<SpoiledSnowmanEntity> rangeAttackGoal;
    @NotNull
    private final AnimatedMeleeAttackGoal<SpoiledSnowmanEntity> meleeAttackGoal;
    private boolean patrolLeader;
    private int movingTicks;
    private int ourDeathTime;
    private final AnimatableInstanceCache animatableInstanceCache;
    @NotNull
    public static final String PATROL_LEADER_NBT_NAME = "SpoiledPatrolLeader";
    @NotNull
    private static final EntityDataAccessor<Boolean> PATROL_LEADER_ID;
    private static final RawAnimation ANIMATION_IDLE_1;
    private static final RawAnimation ANIMATION_ATTACK_1;
    private static final RawAnimation ANIMATION_ATTACK_2;
    private static final RawAnimation ANIMATION_WALK;
    private static final RawAnimation ANIMATION_DEATH;

    public SpoiledSnowmanEntity(@NotNull EntityType<? extends SpoiledSnowmanEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.rangeAttackGoal = new AnimatedRangedAttackGoal<PathfinderMob>(this, 1.0, 15, 14);
        this.meleeAttackGoal = new AnimatedMeleeAttackGoal<PathfinderMob>(this, 1.0, 12, 8, 0);
        this.f_21364_ = 5;
        this.f_21345_.m_25352_(1, (Goal)this.meleeAttackGoal);
        this.animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
    }

    private final void removeAllAttackGoals() {
        this.f_21345_.m_25363_((Goal)this.rangeAttackGoal);
        this.f_21345_.m_25363_((Goal)this.meleeAttackGoal);
    }

    public final boolean getPatrolLeader() {
        Object object = this.f_19804_.m_135370_(PATROL_LEADER_ID);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.entityData.get(PATROL_LEADER_ID)");
        return (Boolean)object;
    }

    public final void setPatrolLeader(boolean value) {
        this.patrolLeader = value;
        this.f_19804_.m_135381_(PATROL_LEADER_ID, (Object)this.patrolLeader);
        this.removeAllAttackGoals();
        if (value) {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22276_);
            if (attributeInstance != null) {
                attributeInstance.m_22100_(30.0);
            }
            this.m_21153_(this.m_21233_());
        }
        this.f_21345_.m_25352_(1, value ? (Goal)this.rangeAttackGoal : (Goal)this.meleeAttackGoal);
        this.f_21364_ = value ? 6 : 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        Class[] classArray = new Class[]{SpoiledSnowmanEntity.class};
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, classArray).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true, SpoiledSnowmanEntity::registerGoals$lambda$0));
    }

    public final int getMovingTicks() {
        return this.movingTicks;
    }

    public final void setMovingTicks(int n) {
        this.movingTicks = n;
    }

    public void m_8119_() {
        boolean moving;
        super.m_8119_();
        boolean bl = moving = Math.abs(this.m_20184_().f_82479_) > 0.0 || Math.abs(this.m_20184_().f_82481_) > 0.0;
        if (moving) {
            int n = this.movingTicks;
            this.movingTicks = n + 1;
            if (this.movingTicks % 19 == 0) {
                this.m_5496_(SoundEvents.f_12284_, 0.15f, 1.0f);
            }
        } else if (this.movingTicks > 0) {
            this.movingTicks = 0;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PATROL_LEADER_ID, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7380_(tag);
        tag.m_128379_(PATROL_LEADER_NBT_NAME, this.getPatrolLeader());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7378_(tag);
        if (tag.m_128425_(PATROL_LEADER_NBT_NAME, 1)) {
            this.setPatrolLeader(tag.m_128471_(PATROL_LEADER_NBT_NAME));
        }
    }

    protected void m_7472_(@NotNull DamageSource damageSource, int p_21386_, boolean alwaysDrop) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
            super.m_7472_(damageSource, p_21386_, alwaysDrop);
            if (!this.getPatrolLeader()) break block2;
            ItemEntity itemEntity = this.m_19998_((ItemLike)ModItems.INSTANCE.getCANDY_CANE().get());
            if (itemEntity != null) {
                itemEntity.m_32064_();
            }
            ItemEntity itemEntity2 = this.m_19998_((ItemLike)ModItems.INSTANCE.getSNOWMAN_HAT().get());
            if (itemEntity2 != null) {
                itemEntity2.m_32064_();
            }
        }
    }

    @Override
    public void m_6504_(@NotNull LivingEntity targetEntity, float strength) {
        boolean melee;
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        boolean bl = melee = targetEntity.m_20280_((Entity)this) < Math.pow(3.0, 2);
        if (melee) {
            this.m_6674_(InteractionHand.MAIN_HAND);
            this.m_7327_((Entity)targetEntity);
        } else if (this.getPatrolLeader()) {
            this.m_5496_((SoundEvent)ModSoundEvents.INSTANCE.getWOOSH().get(), 1.0f, 1.0f);
            super.m_6504_(targetEntity, strength);
        }
    }

    public boolean m_271807_() {
        return this.m_5448_() != null;
    }

    protected void m_6153_() {
        int n = this.ourDeathTime;
        this.ourDeathTime = n + 1;
        Level world = this.m_9236_();
        if (this.ourDeathTime >= 30 && !world.m_5776_() && !this.m_213877_()) {
            world.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.m_6667_(damageSource);
        this.triggerAnim("controllerDeath", "death");
        this.m_5496_(SoundEvents.f_144205_, 1.0f, 1.0f);
    }

    public void m_147240_(double velX, double velY, double velZ) {
    }

    protected void m_7355_(@NotNull BlockPos blockPos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    @Override
    @NotNull
    protected SoundEvent m_7515_() {
        Object object = ModSoundEvents.INSTANCE.getSPOILED_SNOWMAN_IDLE().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ModSoundEvents.SPOILED_SNOWMAN_IDLE.get()");
        return (SoundEvent)object;
    }

    protected float m_6121_() {
        return 0.15f;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllerRegistrar) {
        Intrinsics.checkNotNullParameter((Object)controllerRegistrar, (String)"controllerRegistrar");
        AnimationController[] animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", SpoiledSnowmanEntity::registerControllers$lambda$1)};
        controllerRegistrar.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerAttack", SpoiledSnowmanEntity::registerControllers$lambda$2).triggerableAnim("attack1", ANIMATION_ATTACK_1).triggerableAnim("attack2", ANIMATION_ATTACK_2)};
        controllerRegistrar.add(animationControllerArray);
        animationControllerArray = new AnimationController[]{new AnimationController((GeoAnimatable)this, "controllerDeath", SpoiledSnowmanEntity::registerControllers$lambda$3).triggerableAnim("death", ANIMATION_DEATH)};
        controllerRegistrar.add(animationControllerArray);
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.animatableInstanceCache;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"this.animatableInstanceCache");
        return animatableInstanceCache;
    }

    @Override
    public void playAttackAnimation() {
        LivingEntity targetEntity = this.m_5448_();
        if (targetEntity != null) {
            boolean melee;
            boolean bl = melee = targetEntity.m_20280_((Entity)this) < Math.pow(3.0, 2);
            if (melee) {
                this.playMeleeAttackAnimation();
            } else if (this.getPatrolLeader()) {
                this.playRangeAttackAnimation();
            }
        }
    }

    @Override
    public void playMeleeAttackAnimation() {
        this.triggerAnim("controllerAttack", this.getPatrolLeader() ? "attack2" : (this.f_19796_.m_188503_(2) == 0 ? "attack1" : "attack2"));
    }

    @Override
    public void playRangeAttackAnimation() {
        this.triggerAnim("controllerAttack", "attack1");
    }

    @Override
    public void tickAttackAnimation(int ticks, int duration) {
        IRangeAttackAnimatable.DefaultImpls.tickAttackAnimation(this, ticks, duration);
    }

    private static final boolean registerGoals$lambda$0(LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        return !livingEntity.m_6162_();
    }

    private static final PlayState registerControllers$lambda$1(AnimationState state) {
        return state.setAndContinue(state.isMoving() ? ANIMATION_WALK : ANIMATION_IDLE_1);
    }

    private static final PlayState registerControllers$lambda$2(AnimationState it) {
        return PlayState.STOP;
    }

    private static final PlayState registerControllers$lambda$3(AnimationState it) {
        return PlayState.STOP;
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(SpoiledSnowmanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(\n            Sp\u2026alizers.BOOLEAN\n        )");
        PATROL_LEADER_ID = entityDataAccessor;
        ANIMATION_IDLE_1 = RawAnimation.begin().thenPlay("idle_1");
        ANIMATION_ATTACK_1 = RawAnimation.begin().thenPlay("attack_1");
        ANIMATION_ATTACK_2 = RawAnimation.begin().thenPlay("attack_2");
        ANIMATION_WALK = RawAnimation.begin().thenPlay("walk");
        ANIMATION_DEATH = RawAnimation.begin().thenPlay("death");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/moddercoder/immortalgingerbread/entity/SpoiledSnowmanEntity$Companion;", "", "()V", "ANIMATION_ATTACK_1", "Lsoftware/bernie/geckolib/core/animation/RawAnimation;", "kotlin.jvm.PlatformType", "ANIMATION_ATTACK_2", "ANIMATION_DEATH", "ANIMATION_IDLE_1", "ANIMATION_WALK", "PATROL_LEADER_ID", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "PATROL_LEADER_NBT_NAME", "", "immortalgingerbread-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

