/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortalgingerbread.entity;

import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.moddercoder.immortalgingerbread.entity.ISpoiledPatrolEntity;
import net.moddercoder.immortalgingerbread.entity.ai.goal.PathfindToSpoiledRaidGoal;
import net.moddercoder.immortalgingerbread.entity.ai.goal.SpoiledRaiderMoveThroughVillageGoal;
import net.moddercoder.immortalgingerbread.entity.raid.SpoiledRaid;
import net.moddercoder.immortalgingerbread.mixinexpander.IServerLevelExpander;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0004\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\tH&J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0016J6\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010&2\b\u0010.\u001a\u0004\u0018\u00010\u001cH\u0017J\b\u0010/\u001a\u0004\u0018\u00010\u000bJ\u0006\u00100\u001a\u00020\tJ\u0018\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020!2\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u00106\u001a\u00020\u001aH\u0014J\u0010\u00107\u001a\u00020\t2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\tH\u0016J\u000e\u0010;\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010<\u001a\u00020\u001a2\b\u0010\n\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006="}, d2={"Lnet/moddercoder/immortalgingerbread/entity/AbstractSpoiledPatrolEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "Lnet/moddercoder/immortalgingerbread/entity/ISpoiledPatrolEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "canJoinRaid", "", "raid", "Lnet/moddercoder/immortalgingerbread/entity/raid/SpoiledRaid;", "getRaid", "()Lnet/moddercoder/immortalgingerbread/entity/raid/SpoiledRaid;", "setRaid", "(Lnet/moddercoder/immortalgingerbread/entity/raid/SpoiledRaid;)V", "ticksOutsideRaid", "", "getTicksOutsideRaid", "()I", "setTicksOutsideRaid", "(I)V", "wave", "getWave", "setWave", "addAdditionalSaveData", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "applyRaidBuffs", "unknown", "die", "p_21014_", "Lnet/minecraft/world/damagesource/DamageSource;", "doHurtTarget", "targetEntity", "Lnet/minecraft/world/entity/Entity;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "p_21434_", "Lnet/minecraft/world/level/ServerLevelAccessor;", "p_21435_", "Lnet/minecraft/world/DifficultyInstance;", "p_21436_", "Lnet/minecraft/world/entity/MobSpawnType;", "p_21437_", "p_21438_", "getCurrentRaid", "hasActiveRaid", "hurt", "damageSource", "damage", "", "readAdditionalSaveData", "registerGoals", "removeWhenFarAway", "distance", "", "requiresCustomPersistence", "setCanJoinRaid", "setCurrentRaid", "immortalgingerbread-1.20.1"})
public abstract class AbstractSpoiledPatrolEntity
extends Monster
implements ISpoiledPatrolEntity {
    private int wave;
    private int ticksOutsideRaid;
    private boolean canJoinRaid;
    @Nullable
    private SpoiledRaid raid;

    public AbstractSpoiledPatrolEntity(@NotNull EntityType<? extends Monster> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
    }

    public abstract void applyRaidBuffs(int var1, boolean var2);

    public final int getWave() {
        return this.wave;
    }

    public final void setWave(int n) {
        this.wave = n;
    }

    public final int getTicksOutsideRaid() {
        return this.ticksOutsideRaid;
    }

    public final void setTicksOutsideRaid(int n) {
        this.ticksOutsideRaid = n;
    }

    public final void setCanJoinRaid(boolean canJoinRaid) {
        this.canJoinRaid = canJoinRaid;
    }

    public final boolean canJoinRaid() {
        return this.canJoinRaid;
    }

    @Nullable
    protected final SpoiledRaid getRaid() {
        return this.raid;
    }

    protected final void setRaid(@Nullable SpoiledRaid spoiledRaid) {
        this.raid = spoiledRaid;
    }

    public final void setCurrentRaid(@Nullable SpoiledRaid raid) {
        this.raid = raid;
    }

    @Nullable
    public final SpoiledRaid getCurrentRaid() {
        return this.raid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasActiveRaid() {
        if (this.raid == null) return false;
        SpoiledRaid spoiledRaid = this.raid;
        Intrinsics.checkNotNull((Object)spoiledRaid);
        if (!spoiledRaid.isActive()) return false;
        return true;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(-2, (Goal)new PathfindToSpoiledRaidGoal<AbstractSpoiledPatrolEntity>(this));
        this.f_21345_.m_25352_(-1, (Goal)new SpoiledRaiderMoveThroughVillageGoal(this, 1.05, 1));
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7378_(tag);
        this.wave = tag.m_128451_("Wave");
        this.canJoinRaid = tag.m_128471_("CanJoinRaid");
        if (tag.m_128425_("RaidId", 3)) {
            if (this.m_9236_() instanceof ServerLevel) {
                Level level = this.m_9236_();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.moddercoder.immortalgingerbread.mixinexpander.IServerLevelExpander");
                this.raid = ((IServerLevelExpander)level).getSpoiledRaids().get(tag.m_128451_("RaidId"));
            }
            if (this.raid != null) {
                SpoiledRaid spoiledRaid = this.raid;
                Intrinsics.checkNotNull((Object)spoiledRaid);
                spoiledRaid.addWaveMob(this.wave, this, false);
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.m_7380_(tag);
        tag.m_128405_("Wave", this.wave);
        tag.m_128379_("CanJoinRaid", this.canJoinRaid);
        if (this.raid != null) {
            SpoiledRaid spoiledRaid = this.raid;
            Intrinsics.checkNotNull((Object)spoiledRaid);
            tag.m_128405_("RaidId", spoiledRaid.getId());
        }
    }

    public boolean m_6785_(double distance) {
        return this.raid == null ? super.m_6785_(distance) : false;
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.raid != null;
    }

    public void m_6667_(@NotNull DamageSource p_21014_) {
        Intrinsics.checkNotNullParameter((Object)p_21014_, (String)"p_21014_");
        if (this.m_9236_() instanceof ServerLevel) {
            Entity entity = p_21014_.m_7639_();
            SpoiledRaid raid = this.getCurrentRaid();
            if (raid != null) {
                if (entity != null && entity.m_6095_() == EntityType.f_20532_) {
                    raid.addHeroOfTheVillage(entity);
                }
                raid.removeFromRaid(this, false);
            }
        }
        super.m_6667_(p_21014_);
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float damage) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (this.hasActiveRaid()) {
            SpoiledRaid spoiledRaid = this.raid;
            Intrinsics.checkNotNull((Object)spoiledRaid);
            spoiledRaid.updateBossbar();
        }
        return super.m_6469_(damageSource, damage);
    }

    public boolean m_7327_(@NotNull Entity targetEntity) {
        Intrinsics.checkNotNullParameter((Object)targetEntity, (String)"targetEntity");
        if (targetEntity instanceof ISpoiledPatrolEntity) {
            return false;
        }
        return super.m_7327_(targetEntity);
    }

    @Deprecated(message="Deprecated in Java")
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor p_21434_, @NotNull DifficultyInstance p_21435_, @NotNull MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        Intrinsics.checkNotNullParameter((Object)p_21434_, (String)"p_21434_");
        Intrinsics.checkNotNullParameter((Object)p_21435_, (String)"p_21435_");
        Intrinsics.checkNotNullParameter((Object)p_21436_, (String)"p_21436_");
        this.setCanJoinRaid(p_21436_ != MobSpawnType.NATURAL);
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }
}

