import json
import os
from pathlib import Path

# Список биомов
biome_list = [
    "minecraft:bamboo_jungle",
    "minecraft:beach",
    "minecraft:birch_forest",
    "minecraft:cold_ocean",
    "minecraft:dark_forest",
    "minecraft:desert",
    "minecraft:deep_dark",
    "minecraft:lush_caves",
    "minecraft:meadow",
    "#aquamirae:ice_maze",
    "minecraft:savanna",
    "minecraft:taiga"
]

def create_biome_tag(biome_id: str):
    """Создает JSON-файл тега для одного биома"""
    namespace, biome_name = biome_id.split(":")
    filename = f"{biome_name}.json"
    # Создаем данные тега
    tag_data = {
        "replace": False,
        "values": [biome_id]
    }
    
    # Сохраняем файл в текущую директорию
    with open(filename, 'w', encoding='utf-8') as f:
        json.dump(tag_data, f, indent=2, ensure_ascii=False)
    
    return filename

print("Создание тегов биомов в текущей папке...")
created_files = []

for biome in biome_list:
    if biome.strip():  # Пропускаем пустые строки
        try:
            created_file = create_biome_tag(biome)
            created_files.append(created_file)
        except ValueError as e:
            print(f"Ошибка в строке '{biome}': {e}")

print(f"\nУспешно создано {len(created_files)} файлов:")
for file in created_files:
    print(f"- {file}")

print("\nФайлы сохранены в:", Path.cwd())
