/*
 * Decompiled with CFR 0.152.
 */
package net.moddercoder.immortaldroid.event;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.moddercoder.immortaldroid.entity.DroidEntity;
import net.moddercoder.immortaldroid.storage.BiboSavedData;
import net.moddercoder.immortaldroid.storage.ModSavedData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lnet/moddercoder/immortaldroid/event/ModEvents;", "", "()V", "onAdvancementEarned", "", "event", "Lnet/minecraftforge/event/entity/player/AdvancementEvent$AdvancementEarnEvent;", "onAdvancementProgressEvent", "Lnet/minecraftforge/event/entity/player/AdvancementEvent$AdvancementProgressEvent;", "immortaldroid-1.20.1"})
public final class ModEvents {
    @SubscribeEvent
    public final void onAdvancementEarned(@NotNull AdvancementEvent.AdvancementEarnEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Player player = event.getEntity();
        Advancement advancement = event.getAdvancement();
        if (advancement.m_138320_() == null) {
            return;
        }
        if (player != null) {
            BiboSavedData biboSavedData = ModSavedData.INSTANCE.getBiboData();
            if (biboSavedData != null) {
                UUID uUID = player.m_20148_();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
                ResourceLocation[] resourceLocationArray = new ResourceLocation[1];
                Intrinsics.checkNotNullExpressionValue((Object)advancement.m_138327_(), (String)"advancement.id");
                BiboSavedData.cacheAdvancement$default(biboSavedData, uUID, resourceLocationArray, false, 4, null);
            }
            Level level = player.m_9236_();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"player.level()");
            BlockPos blockPos = player.m_20183_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"player.blockPosition()");
            DroidEntity.Companion.invokeCheckOwnerForNearbyBibos(level, blockPos);
        }
    }

    @SubscribeEvent
    public final void onAdvancementProgressEvent(@NotNull AdvancementEvent.AdvancementProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getProgressType() == AdvancementEvent.AdvancementProgressEvent.ProgressType.REVOKE) {
            Player player = event.getEntity();
            Advancement advancement = event.getAdvancement();
            if (advancement.m_138320_() == null) {
                return;
            }
            if (player != null) {
                BiboSavedData biboSavedData = ModSavedData.INSTANCE.getBiboData();
                if (biboSavedData != null) {
                    UUID uUID = player.m_20148_();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"player.uuid");
                    ResourceLocation[] resourceLocationArray = new ResourceLocation[1];
                    Intrinsics.checkNotNullExpressionValue((Object)advancement.m_138327_(), (String)"advancement.id");
                    BiboSavedData.uncacheAdvancement$default(biboSavedData, uUID, resourceLocationArray, false, 4, null);
                }
                Level level = player.m_9236_();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"player.level()");
                BlockPos blockPos = player.m_20183_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"player.blockPosition()");
                DroidEntity.Companion.invokeCheckOwnerForNearbyBibos(level, blockPos);
            }
        }
    }
}

