/*
 * Decompiled with CFR 0.152.
 */
package net.walksanator.hextweaks.casting.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.walksanator.hextweaks.casting.actions.VariableMediaActionResult;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.casting.iota.StringIota;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\r\u001a\u00020\f8\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lnet/walksanator/hextweaks/casting/actions/OpEgyptianPlagues;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "<init>", "()V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "", "argc", "I", "getArgc", "()I", "EgyptianPlague", "hextweaks"})
public final class OpEgyptianPlagues
implements SpellAction {
    @NotNull
    public static final OpEgyptianPlagues INSTANCE = new OpEgyptianPlagues();
    private static final int argc = 4;

    private OpEgyptianPlagues() {
    }

    public int getArgc() {
        return argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        LivingEntity target = OperatorUtils.getLivingEntityButNotArmorStand(args, (int)0, (int)this.getArgc());
        env.assertEntityInRange((Entity)target);
        Iota plague = args.get(1);
        if (!(plague instanceof StringIota)) {
            throw MishapInvalidIota.Companion.ofType(plague, 3, "string");
        }
        String plagueId = ((StringIota)plague).getString();
        Optional optional = ResourceLocation.m_135837_((String)plagueId).result();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"result(...)");
        ResourceLocation resourceLocation = (ResourceLocation)OptionalsKt.getOrNull((Optional)optional);
        if (resourceLocation == null) {
            throw MishapInvalidIota.Companion.of(plague, 3, "resloc", new Object[0]);
        }
        ResourceLocation realPlague = resourceLocation;
        MobEffect mobEffect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(realPlague);
        if (mobEffect == null) {
            throw MishapInvalidIota.Companion.of(plague, 3, "mobeffect", new Object[0]);
        }
        MobEffect thePlague = mobEffect;
        int duration = Math.max(Math.abs(OperatorUtils.getInt(args, (int)2, (int)this.getArgc())), 1) * 20;
        int potency = Math.max(OperatorUtils.getInt(args, (int)3, (int)this.getArgc()), 1);
        MobEffectInstance mobi = new MobEffectInstance(thePlague, duration, potency);
        return new SpellAction.Result((RenderedSpell)new EgyptianPlague(mobi, target), (long)(plagueId.length() * (mobi.m_19557_() / 20)) * (long)Math.pow(mobi.m_19564_(), 4) * 10000L, CollectionsKt.emptyList(), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lnet/walksanator/hextweaks/casting/actions/OpEgyptianPlagues$EgyptianPlague;", "Lnet/walksanator/hextweaks/casting/actions/VariableMediaActionResult;", "Lnet/minecraft/world/effect/MobEffectInstance;", "effect", "Lnet/minecraft/world/entity/LivingEntity;", "target", "<init>", "(Lnet/minecraft/world/effect/MobEffectInstance;Lnet/minecraft/world/entity/LivingEntity;)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "execute", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Ljava/util/List;", "Lnet/minecraft/world/effect/MobEffectInstance;", "getEffect", "()Lnet/minecraft/world/effect/MobEffectInstance;", "Lnet/minecraft/world/entity/LivingEntity;", "getTarget", "()Lnet/minecraft/world/entity/LivingEntity;", "hextweaks"})
    private static final class EgyptianPlague
    extends VariableMediaActionResult {
        @NotNull
        private final MobEffectInstance effect;
        @NotNull
        private final LivingEntity target;

        public EgyptianPlague(@NotNull MobEffectInstance effect, @NotNull LivingEntity target) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.effect = effect;
            this.target = target;
        }

        @NotNull
        public final MobEffectInstance getEffect() {
            return this.effect;
        }

        @NotNull
        public final LivingEntity getTarget() {
            return this.target;
        }

        @Override
        @NotNull
        public List<Iota> execute(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            this.target.m_7292_(this.effect);
            return CollectionsKt.emptyList();
        }
    }
}

