/*
 * Decompiled with CFR 0.152.
 */
package net.walksanator.hextweaks.casting.actions;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\f\u001a\u00020\u000b2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0012\u001a\u00020\u00118\u0016X\u0096D\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lnet/walksanator/hextweaks/casting/actions/OpBiggerBomb;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "", "fireball", "<init>", "(Z)V", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "args", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "execute", "(Ljava/util/List;Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "Z", "getFireball", "()Z", "", "argc", "I", "getArgc", "()I", "Spell", "hextweaks"})
public final class OpBiggerBomb
implements SpellAction {
    private final boolean fireball;
    private final int argc;

    public OpBiggerBomb(boolean fireball) {
        this.fireball = fireball;
        this.argc = 2;
    }

    public final boolean getFireball() {
        return this.fireball;
    }

    public int getArgc() {
        return this.argc;
    }

    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Vec3 pos = OperatorUtils.getVec3(args, (int)0, (int)this.getArgc());
        double strength = OperatorUtils.getPositiveDoubleUnderInclusive(args, (int)1, (double)20.0, (int)this.getArgc());
        env.assertVecInRange(pos);
        double clampedStrength = Mth.m_14008_((double)strength, (double)0.0, (double)10.0);
        double cost = (double)10000L * ((double)3 * clampedStrength + (this.fireball ? 1.0 : 0.125));
        return new SpellAction.Result((RenderedSpell)new Spell(pos, strength, this.fireball), (long)cost, CollectionsKt.listOf((Object)ParticleSpray.Companion.burst(pos, strength, 50)), 0L, 8, null);
    }

    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata((SpellAction)this, args, (CastingEnvironment)env, (CompoundTag)userData);
    }

    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound((SpellAction)this, (CastingEnvironment)ctx);
    }

    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate((SpellAction)this, (CastingEnvironment)env, (CastingImage)image, (SpellContinuation)continuation);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J.\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0014\u00a8\u0006'"}, d2={"Lnet/walksanator/hextweaks/casting/actions/OpBiggerBomb$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "Lnet/minecraft/world/phys/Vec3;", "pos", "", "strength", "", "fire", "<init>", "(Lnet/minecraft/world/phys/Vec3;DZ)V", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "env", "", "cast", "(Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;)V", "component1", "()Lnet/minecraft/world/phys/Vec3;", "component2", "()D", "component3", "()Z", "copy", "(Lnet/minecraft/world/phys/Vec3;DZ)Lnet/walksanator/hextweaks/casting/actions/OpBiggerBomb$Spell;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lnet/minecraft/world/phys/Vec3;", "getPos", "D", "getStrength", "Z", "getFire", "hextweaks"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final Vec3 pos;
        private final double strength;
        private final boolean fire;

        public Spell(@NotNull Vec3 pos, double strength, boolean fire) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            this.pos = pos;
            this.strength = strength;
            this.fire = fire;
        }

        @NotNull
        public final Vec3 getPos() {
            return this.pos;
        }

        public final double getStrength() {
            return this.strength;
        }

        public final boolean getFire() {
            return this.fire;
        }

        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (!env.canEditBlockAt(BlockPos.m_274446_((Position)((Position)this.pos)))) {
                return;
            }
            env.getWorld().m_255391_((Entity)env.getCastingEntity(), this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, (float)this.strength, this.fire, Level.ExplosionInteraction.TNT);
        }

        @NotNull
        public final Vec3 component1() {
            return this.pos;
        }

        public final double component2() {
            return this.strength;
        }

        public final boolean component3() {
            return this.fire;
        }

        @NotNull
        public final Spell copy(@NotNull Vec3 pos, double strength, boolean fire) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return new Spell(pos, strength, fire);
        }

        public static /* synthetic */ Spell copy$default(Spell spell, Vec3 vec3, double d, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                vec3 = spell.pos;
            }
            if ((n & 2) != 0) {
                d = spell.strength;
            }
            if ((n & 4) != 0) {
                bl = spell.fire;
            }
            return spell.copy(vec3, d, bl);
        }

        @NotNull
        public String toString() {
            return "Spell(pos=" + this.pos + ", strength=" + this.strength + ", fire=" + this.fire + ")";
        }

        public int hashCode() {
            int result = this.pos.hashCode();
            result = result * 31 + Double.hashCode(this.strength);
            result = result * 31 + Boolean.hashCode(this.fire);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Spell)) {
                return false;
            }
            Spell spell = (Spell)other;
            if (!Intrinsics.areEqual((Object)this.pos, (Object)spell.pos)) {
                return false;
            }
            if (Double.compare(this.strength, spell.strength) != 0) {
                return false;
            }
            return this.fire == spell.fire;
        }

        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast((RenderedSpell)this, (CastingEnvironment)env, (CastingImage)image);
        }
    }
}

