/*
 * Decompiled with CFR 0.152.
 */
package net.walksanator.hextweaks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.walksanator.hextweaks.SecurityLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B5\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013R\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR.\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lnet/walksanator/hextweaks/HexTweaksConfig;", "", "", "computerAmbitMult", "computerCostMult", "", "", "computerBanList", "Lnet/walksanator/hextweaks/SecurityLevel;", "allowUnsafeDeserialization", "<init>", "(FFLjava/util/List;Lnet/walksanator/hextweaks/SecurityLevel;)V", "Lnet/minecraft/resources/ResourceLocation;", "pattern", "", "isPatternAllowed", "(Lnet/minecraft/resources/ResourceLocation;)Z", "F", "getComputerAmbitMult", "()F", "getComputerCostMult", "Ljava/util/List;", "getComputerBanList", "()Ljava/util/List;", "Lnet/walksanator/hextweaks/SecurityLevel;", "getAllowUnsafeDeserialization", "()Lnet/walksanator/hextweaks/SecurityLevel;", "", "allowCache", "Ljava/util/Map;", "getAllowCache", "()Ljava/util/Map;", "setAllowCache", "(Ljava/util/Map;)V", "Companion", "hextweaks"})
public final class HexTweaksConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float computerAmbitMult;
    private final float computerCostMult;
    @NotNull
    private final List<String> computerBanList;
    @NotNull
    private final SecurityLevel allowUnsafeDeserialization;
    @NotNull
    private transient Map<ResourceLocation, Boolean> allowCache;
    @NotNull
    private static final HexTweaksConfig DEFAULT = new HexTweaksConfig(0.0f, 0.0f, null, null, 15, null);
    private static final Codec<Either<HexTweaksConfig, HexTweaksConfig>> CODEC = Codec.either((Codec)RecordCodecBuilder.create(HexTweaksConfig::CODEC$lambda$4), (Codec)Codec.unit((Object)DEFAULT));

    public HexTweaksConfig(float computerAmbitMult, float computerCostMult, @NotNull List<String> computerBanList, @NotNull SecurityLevel allowUnsafeDeserialization) {
        Intrinsics.checkNotNullParameter(computerBanList, (String)"computerBanList");
        Intrinsics.checkNotNullParameter((Object)((Object)allowUnsafeDeserialization), (String)"allowUnsafeDeserialization");
        this.computerAmbitMult = computerAmbitMult;
        this.computerCostMult = computerCostMult;
        this.computerBanList = computerBanList;
        this.allowUnsafeDeserialization = allowUnsafeDeserialization;
        this.allowCache = new LinkedHashMap();
    }

    public /* synthetic */ HexTweaksConfig(float f, float f2, List list, SecurityLevel securityLevel, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        if ((n & 2) != 0) {
            f2 = 1.0f;
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            securityLevel = SecurityLevel.TRUENAME;
        }
        this(f, f2, list, securityLevel);
    }

    public final float getComputerAmbitMult() {
        return this.computerAmbitMult;
    }

    public final float getComputerCostMult() {
        return this.computerCostMult;
    }

    @NotNull
    public final List<String> getComputerBanList() {
        return this.computerBanList;
    }

    @NotNull
    public final SecurityLevel getAllowUnsafeDeserialization() {
        return this.allowUnsafeDeserialization;
    }

    @NotNull
    public final Map<ResourceLocation, Boolean> getAllowCache() {
        return this.allowCache;
    }

    public final void setAllowCache(@NotNull Map<ResourceLocation, Boolean> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.allowCache = map;
    }

    public final boolean isPatternAllowed(@Nullable ResourceLocation pattern) {
        if (pattern == null) {
            return true;
        }
        if (this.allowCache.containsKey(pattern)) {
            Boolean bl = this.allowCache.get(pattern);
            Intrinsics.checkNotNull((Object)bl);
            return bl;
        }
        boolean allowed = !this.computerBanList.contains(pattern.toString());
        Boolean bl = allowed;
        this.allowCache.put(pattern, bl);
        return allowed;
    }

    private static final Float CODEC$lambda$4$lambda$0(HexTweaksConfig it) {
        return Float.valueOf(it.computerAmbitMult);
    }

    private static final Float CODEC$lambda$4$lambda$1(HexTweaksConfig it) {
        return Float.valueOf(it.computerCostMult);
    }

    private static final List CODEC$lambda$4$lambda$2(HexTweaksConfig it) {
        return it.computerBanList;
    }

    private static final SecurityLevel CODEC$lambda$4$lambda$3(HexTweaksConfig it) {
        return it.allowUnsafeDeserialization;
    }

    private static final App CODEC$lambda$4(RecordCodecBuilder.Instance it) {
        return it.group((App)Codec.FLOAT.fieldOf("computerAmbitMult").forGetter(HexTweaksConfig::CODEC$lambda$4$lambda$0), (App)Codec.FLOAT.fieldOf("computerCostMult").forGetter(HexTweaksConfig::CODEC$lambda$4$lambda$1), (App)Codec.STRING.listOf().fieldOf("computerBanList").forGetter(HexTweaksConfig::CODEC$lambda$4$lambda$2), (App)StringRepresentable.m_216439_(SecurityLevel::values).fieldOf("allowUnsafeDeserialization").forGetter(HexTweaksConfig::CODEC$lambda$4$lambda$3)).apply((Applicative)it, HexTweaksConfig::new);
    }

    public HexTweaksConfig() {
        this(0.0f, 0.0f, null, null, 15, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u00ac\u0001\u0010\f\u001a\u0096\u0001\u0012D\u0012B\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\n0\n \u000b*J\u0012D\u0012B\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\n0\n\u0018\u00010\t0\t8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/walksanator/hextweaks/HexTweaksConfig$Companion;", "", "<init>", "()V", "Lnet/walksanator/hextweaks/HexTweaksConfig;", "DEFAULT", "Lnet/walksanator/hextweaks/HexTweaksConfig;", "getDEFAULT", "()Lnet/walksanator/hextweaks/HexTweaksConfig;", "Lcom/mojang/serialization/Codec;", "Lcom/mojang/datafixers/util/Either;", "kotlin.jvm.PlatformType", "CODEC", "Lcom/mojang/serialization/Codec;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "hextweaks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HexTweaksConfig getDEFAULT() {
            return DEFAULT;
        }

        public final Codec<Either<HexTweaksConfig, HexTweaksConfig>> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

