/*
 * Decompiled with CFR 0.152.
 */
package net.walksanator.hextweaks;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.platform.Platform;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.walksanator.hextweaks.HexTweaksCommands;
import net.walksanator.hextweaks.HexTweaksConfig;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vazkii.patchouli.api.PatchouliAPI;

public class HexTweaks {
    public static final String MOD_ID = "hextweaks";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hextweaks");
    @Nullable
    static HexTweaksConfig CONFIG = null;

    @NotNull
    public static HexTweaksConfig getCONFIG() {
        boolean makeFile = false;
        Path res = Platform.getConfigFolder().resolve("hextweaks.json");
        if (CONFIG == null) {
            try {
                Either either = (Either)HexTweaksConfig.Companion.getCODEC().parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)new FileReader(res.toFile()))).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
                Optional right = either.right();
                if (right.isPresent()) {
                    makeFile = true;
                    LOGGER.warn("Hextweaks config was not setup right, it has been reset to default.");
                    CONFIG = (HexTweaksConfig)right.get();
                } else {
                    LOGGER.info("Hextweaks config loaded successfully");
                    CONFIG = (HexTweaksConfig)either.left().get();
                }
            }
            catch (Exception e) {
                LOGGER.error("Hextweaks config does not exists. defaulting");
                makeFile = true;
                CONFIG = HexTweaksConfig.Companion.getDEFAULT();
            }
        }
        if (makeFile) {
            DataResult result = HexTweaksConfig.Companion.getCODEC().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)Either.left((Object)CONFIG));
            String output = new Gson().toJson((JsonElement)result.result().get());
            try {
                Files.writeString(res, (CharSequence)output, new OpenOption[0]);
            }
            catch (IOException e) {
                LOGGER.error("Failed to save hextweaks config to a string");
                e.printStackTrace((PrintStream)LOGGER);
            }
        }
        return CONFIG;
    }

    public static void breakpoint() {
        LOGGER.info("breakpoints sometimes fail. call me instead!");
        new Exception("Breakpoint").printStackTrace();
    }

    public static void init() {
        LOGGER.info("performing COMMON setup");
        CommandRegistrationEvent.EVENT.register((it, b, c) -> HexTweaksCommands.register((CommandDispatcher<CommandSourceStack>)it));
        if (Platform.isModLoaded((String)"computercraft")) {
            PatchouliAPI.get().setConfigFlag("hexcasting:any_interop", true);
        }
        HexTweaks.getCONFIG();
    }
}

