/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.interop.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import vazkii.patchouli.api.IVariable;

public class PatchouliUtils {
    public static <T extends Recipe<C>, C extends Container> T getRecipe(RecipeType<T> type, ResourceLocation id) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return null;
        }
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        return (T)((Recipe)manager.m_44043_(id).filter(recipe -> recipe.m_6671_() == type).orElse(null));
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.get(0).m_43908_()).map(IVariable::from).collect(Collectors.toList()));
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.f_41583_};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.m_43947_()) {
                stacks.add(ingredient.m_43908_());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (ItemStack[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i % stack.length]));
            }
        }
        return IVariable.wrapList(list);
    }

    public static IVariable interweaveIngredients(List<Ingredient> ingredients) {
        return PatchouliUtils.interweaveIngredients(ingredients, ingredients.stream().mapToInt(ingr -> ingr.m_43908_().length).max().orElse(1));
    }
}

