/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.recipe;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class ForgeModConditionalIngredient
extends AbstractIngredient {
    public static final ResourceLocation ID = HexAPI.modLoc("mod_conditional");
    private final Ingredient main;
    private final String modid;
    private final Ingredient ifModLoaded;
    private final Ingredient toUse;

    protected ForgeModConditionalIngredient(Ingredient main, String modid, Ingredient ifModLoaded) {
        super(IXplatAbstractions.INSTANCE.isModPresent(modid) ? Arrays.stream(ifModLoaded.f_43902_) : Arrays.stream(main.f_43902_));
        this.main = main;
        this.modid = modid;
        this.ifModLoaded = ifModLoaded;
        this.toUse = IXplatAbstractions.INSTANCE.isModPresent(modid) ? ifModLoaded : main;
    }

    public static ForgeModConditionalIngredient of(Ingredient main, String modid, Ingredient ifModLoaded) {
        return new ForgeModConditionalIngredient(main, modid, ifModLoaded);
    }

    public boolean test(@Nullable ItemStack input) {
        return this.toUse.test(input);
    }

    public boolean isSimple() {
        return this.toUse.isSimple();
    }

    @NotNull
    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", Objects.toString(ID));
        json.add("default", this.main.m_43942_());
        json.addProperty("modid", this.modid);
        json.add("if_loaded", this.ifModLoaded.m_43942_());
        return json;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public static Ingredient m_43940_(FriendlyByteBuf friendlyByteBuf) {
        return Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf);
    }

    public static Ingredient fromJson(JsonObject object) {
        if (object.has("type") && object.getAsJsonPrimitive("type").getAsString().equals(ID.toString())) {
            if (object.has("modid") && IXplatAbstractions.INSTANCE.isModPresent(object.getAsJsonPrimitive("modid").getAsString())) {
                try {
                    Ingredient ingredient = Ingredient.m_43917_((JsonElement)object.get("if_loaded"));
                    if (!ingredient.m_43947_()) {
                        return ingredient;
                    }
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
            return Ingredient.m_43917_((JsonElement)object.get("default"));
        }
        return Ingredient.m_151265_();
    }

    public static class Serializer
    implements IIngredientSerializer<Ingredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public Ingredient parse(@NotNull FriendlyByteBuf buffer) {
            return ForgeModConditionalIngredient.m_43940_(buffer);
        }

        @NotNull
        public Ingredient parse(@NotNull JsonObject json) {
            return ForgeModConditionalIngredient.fromJson(json);
        }

        public void write(@NotNull FriendlyByteBuf buffer, @NotNull Ingredient ingredient) {
            if (ingredient instanceof ForgeModConditionalIngredient) {
                ForgeModConditionalIngredient conditionalIngredient = (ForgeModConditionalIngredient)ingredient;
                conditionalIngredient.toUse.m_43923_(buffer);
            }
        }
    }
}

