/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.forge.datagen;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.common.lib.HexDamageTypes;
import at.petrak.hexcasting.datagen.HexAdvancements;
import at.petrak.hexcasting.datagen.HexLootTables;
import at.petrak.hexcasting.datagen.IXplatIngredients;
import at.petrak.hexcasting.datagen.recipe.HexplatRecipes;
import at.petrak.hexcasting.datagen.recipe.builders.FarmersDelightToolIngredient;
import at.petrak.hexcasting.datagen.tag.HexActionTagProvider;
import at.petrak.hexcasting.datagen.tag.HexBlockTagProvider;
import at.petrak.hexcasting.datagen.tag.HexDamageTypeTagProvider;
import at.petrak.hexcasting.datagen.tag.HexItemTagProvider;
import at.petrak.hexcasting.forge.datagen.ForgeHexConditionsBuilder;
import at.petrak.hexcasting.forge.datagen.ForgeHexLootModGen;
import at.petrak.hexcasting.forge.datagen.TagsProviderEFHSetter;
import at.petrak.hexcasting.forge.datagen.xplat.HexBlockStatesAndModels;
import at.petrak.hexcasting.forge.datagen.xplat.HexItemModels;
import at.petrak.hexcasting.forge.recipe.ForgeModConditionalIngredient;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import at.petrak.hexcasting.xplat.IXplatTags;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeHexDataGenerators {
    private static final IXplatIngredients INGREDIENTS = new IXplatIngredients(){

        @Override
        public Ingredient glowstoneDust() {
            return Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_GLOWSTONE);
        }

        @Override
        public Ingredient leather() {
            return Ingredient.m_204132_((TagKey)Tags.Items.LEATHER);
        }

        @Override
        public Ingredient ironNugget() {
            return Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_IRON);
        }

        @Override
        public Ingredient goldNugget() {
            return Ingredient.m_204132_((TagKey)Tags.Items.NUGGETS_GOLD);
        }

        @Override
        public Ingredient copperIngot() {
            return Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER);
        }

        @Override
        public Ingredient ironIngot() {
            return Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON);
        }

        @Override
        public Ingredient goldIngot() {
            return Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD);
        }

        @Override
        public EnumMap<DyeColor, Ingredient> dyes() {
            EnumMap<DyeColor, Ingredient> out = new EnumMap<DyeColor, Ingredient>(DyeColor.class);
            for (DyeColor col : DyeColor.values()) {
                out.put(col, Ingredient.m_204132_((TagKey)col.getTag()));
            }
            return out;
        }

        @Override
        public Ingredient stick() {
            return Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(new ItemStack((ItemLike)Items.f_42398_)), new Ingredient.TagValue(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "rods/wooden")))));
        }

        @Override
        public Ingredient whenModIngredient(Ingredient defaultIngredient, String modid, Ingredient modIngredient) {
            return ForgeModConditionalIngredient.of(defaultIngredient, modid, modIngredient);
        }

        @Override
        public FarmersDelightToolIngredient axeStrip() {
            return () -> {
                JsonObject object = new JsonObject();
                object.addProperty("type", "farmersdelight:tool_action");
                object.addProperty("action", ToolActions.AXE_STRIP.name());
                return object;
            };
        }

        @Override
        public FarmersDelightToolIngredient axeDig() {
            return () -> {
                JsonObject object = new JsonObject();
                object.addProperty("type", "farmersdelight:tool_action");
                object.addProperty("action", ToolActions.AXE_DIG.name());
                return object;
            };
        }
    };

    @SubscribeEvent
    public static void generateData(GatherDataEvent ev) {
        if (System.getProperty("hexcasting.xplat_datagen") != null) {
            ForgeHexDataGenerators.configureXplatDatagen(ev);
        }
        if (System.getProperty("hexcasting.forge_datagen") != null) {
            ForgeHexDataGenerators.configureForgeDatagen(ev);
        }
    }

    private static void configureXplatDatagen(GatherDataEvent ev) {
        HexAPI.LOGGER.info("Starting cross-platform datagen");
        DataGenerator gen = ev.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookup = ev.getLookupProvider();
        ExistingFileHelper efh = ev.getExistingFileHelper();
        DatapackBuiltinEntriesProvider datapackProvider = new DatapackBuiltinEntriesProvider(output, lookup, new RegistrySetBuilder().m_254916_(Registries.f_268580_, HexDamageTypes::bootstrap), Set.of("hexcasting"));
        CompletableFuture datapackLookup = datapackProvider.getRegistryProvider();
        gen.addProvider(ev.includeClient(), (DataProvider)new HexItemModels(output, efh));
        gen.addProvider(ev.includeClient(), (DataProvider)new HexBlockStatesAndModels(output, efh));
        gen.addProvider(ev.includeServer(), (DataProvider)new AdvancementProvider(output, lookup, List.of(new HexAdvancements())));
        gen.addProvider(ev.includeServer(), (DataProvider)datapackProvider);
        gen.addProvider(ev.includeServer(), (DataProvider)new HexDamageTypeTagProvider(output, datapackLookup));
    }

    private static void configureForgeDatagen(GatherDataEvent ev) {
        HexAPI.LOGGER.info("Starting Forge-specific datagen");
        DataGenerator gen = ev.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture lookup = ev.getLookupProvider();
        ExistingFileHelper efh = ev.getExistingFileHelper();
        gen.addProvider(ev.includeServer(), (DataProvider)new LootTableProvider(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(HexLootTables::new, LootContextParamSets.f_81420_))));
        gen.addProvider(ev.includeServer(), (DataProvider)new HexplatRecipes(output, INGREDIENTS, ForgeHexConditionsBuilder::new));
        IXplatTags xtags = IXplatAbstractions.INSTANCE.tags();
        HexBlockTagProvider blockTagProvider = new HexBlockTagProvider(output, lookup, xtags);
        ((TagsProviderEFHSetter)((Object)blockTagProvider)).setEFH(efh);
        gen.addProvider(ev.includeServer(), (DataProvider)blockTagProvider);
        HexItemTagProvider itemTagProvider = new HexItemTagProvider(output, lookup, (TagsProvider<Block>)blockTagProvider, IXplatAbstractions.INSTANCE.tags());
        ((TagsProviderEFHSetter)((Object)itemTagProvider)).setEFH(efh);
        gen.addProvider(ev.includeServer(), (DataProvider)itemTagProvider);
        HexActionTagProvider hexTagProvider = new HexActionTagProvider(output, lookup);
        ((TagsProviderEFHSetter)((Object)hexTagProvider)).setEFH(efh);
        gen.addProvider(ev.includeServer(), (DataProvider)hexTagProvider);
        gen.addProvider(ev.includeServer(), (DataProvider)new ForgeHexLootModGen(output));
    }
}

