/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.recipe.ingredient;

import at.petrak.hexcasting.common.recipe.ingredient.StateIngredient;
import at.petrak.hexcasting.common.recipe.ingredient.StateIngredientTag;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StateIngredientTagExcluding
extends StateIngredientTag {
    private final List<StateIngredient> excludes;

    public StateIngredientTagExcluding(ResourceLocation id, Collection<StateIngredient> excludes) {
        super(id);
        this.excludes = List.copyOf(excludes);
    }

    @Override
    public boolean test(BlockState state) {
        if (!super.test(state)) {
            return false;
        }
        return this.isNotExcluded(state);
    }

    @Override
    public BlockState pick(Random random) {
        List<Block> blocks = this.getBlocks();
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks.get(random.nextInt(blocks.size())).m_49966_();
    }

    private boolean isNotExcluded(BlockState state) {
        for (StateIngredient exclude : this.excludes) {
            if (!exclude.test(state)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.excludes.equals(((StateIngredientTagExcluding)o).excludes);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "tag_excluding");
        object.addProperty("tag", this.getTagId().toString());
        JsonArray array = new JsonArray();
        for (StateIngredient exclude : this.excludes) {
            array.add((JsonElement)exclude.serialize());
        }
        object.add("exclude", (JsonElement)array);
        return object;
    }

    @Override
    public List<ItemStack> getDisplayedStacks() {
        return this.getBlocks().stream().filter(b -> b.m_5456_() != Items.f_41852_).map(ItemStack::new).toList();
    }

    @Override
    @NotNull
    protected List<Block> getBlocks() {
        return super.getBlocks().stream().filter(b -> this.isNotExcluded(b.m_49966_())).toList();
    }

    @Override
    public List<BlockState> getDisplayed() {
        return super.getDisplayed().stream().filter(this::isNotExcluded).toList();
    }
}

