/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.msgs;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.client.ClientCastingStack;
import at.petrak.hexcasting.common.msgs.IMessage;
import at.petrak.hexcasting.xplat.IClientXplatAbstractions;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record MsgNewSpiralPatternsS2C(UUID playerUUID, List<HexPattern> patterns, int lifetime) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("spi_pats_sc");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgNewSpiralPatternsS2C deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        UUID player = buf.m_130259_();
        ArrayList patterns = (ArrayList)buf.m_236838_(ArrayList::new, buff -> HexPattern.fromNBT(buf.m_130260_()));
        int lifetime = buf.readInt();
        return new MsgNewSpiralPatternsS2C(player, patterns, lifetime);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.m_236828_(this.patterns, (buff, pattern) -> buff.m_130079_(pattern.serializeToNBT()));
        buf.writeInt(this.lifetime);
    }

    public static void handle(final MsgNewSpiralPatternsS2C self) {
        Minecraft.m_91087_().execute(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.m_91087_();
                assert (mc.f_91073_ != null);
                Player player = mc.f_91073_.m_46003_(self.playerUUID);
                ClientCastingStack stack = IClientXplatAbstractions.INSTANCE.getClientCastingStack(player);
                for (HexPattern pattern : self.patterns) {
                    stack.addPattern(pattern, self.lifetime);
                }
            }
        });
    }
}

