/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.msgs;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.eval.ResolvedPattern;
import at.petrak.hexcasting.api.casting.eval.env.StaffCastEnv;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.common.msgs.IMessage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;

public record MsgNewSpellPatternC2S(InteractionHand handUsed, HexPattern pattern, List<ResolvedPattern> resolvedPatterns) implements IMessage
{
    public static final ResourceLocation ID = HexAPI.modLoc("pat_cs");

    @Override
    public ResourceLocation getFabricId() {
        return ID;
    }

    public static MsgNewSpellPatternC2S deserialize(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        InteractionHand hand = (InteractionHand)buf.m_130066_(InteractionHand.class);
        HexPattern pattern = HexPattern.fromNBT(buf.m_130260_());
        int resolvedPatternsLen = buf.readInt();
        ArrayList<ResolvedPattern> resolvedPatterns = new ArrayList<ResolvedPattern>(resolvedPatternsLen);
        for (int i = 0; i < resolvedPatternsLen; ++i) {
            resolvedPatterns.add(ResolvedPattern.fromNBT(buf.m_130260_()));
        }
        return new MsgNewSpellPatternC2S(hand, pattern, resolvedPatterns);
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.handUsed);
        buf.m_130079_(this.pattern.serializeToNBT());
        buf.writeInt(this.resolvedPatterns.size());
        for (ResolvedPattern pat : this.resolvedPatterns) {
            buf.m_130079_(pat.serializeToNBT());
        }
    }

    public void handle(MinecraftServer server, ServerPlayer sender) {
        server.execute(() -> StaffCastEnv.handleNewPatternOnServer(sender, this));
    }
}

