/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.lib;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.block.circle.BlockAbstractImpetus;
import at.petrak.hexcasting.common.blocks.BlockConjured;
import at.petrak.hexcasting.common.blocks.BlockConjuredLight;
import at.petrak.hexcasting.common.blocks.BlockFlammable;
import at.petrak.hexcasting.common.blocks.BlockQuenchedAllay;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicBookshelf;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicLigature;
import at.petrak.hexcasting.common.blocks.akashic.BlockAkashicRecord;
import at.petrak.hexcasting.common.blocks.circles.BlockEmptyImpetus;
import at.petrak.hexcasting.common.blocks.circles.BlockSlate;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockBooleanDirectrix;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockEmptyDirectrix;
import at.petrak.hexcasting.common.blocks.circles.directrix.BlockRedstoneDirectrix;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockLookingImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockRedstoneImpetus;
import at.petrak.hexcasting.common.blocks.circles.impetuses.BlockRightClickImpetus;
import at.petrak.hexcasting.common.blocks.decoration.BlockAkashicLeaves;
import at.petrak.hexcasting.common.blocks.decoration.BlockAkashicLog;
import at.petrak.hexcasting.common.blocks.decoration.BlockAmethystDirectional;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexDoor;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexFence;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexFenceGate;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexPressurePlate;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexSlab;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexStairs;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexTrapdoor;
import at.petrak.hexcasting.common.blocks.decoration.BlockHexWoodButton;
import at.petrak.hexcasting.common.blocks.decoration.BlockSconce;
import at.petrak.hexcasting.common.lib.HexCreativeTabs;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class HexBlocks {
    private static final Map<ResourceLocation, Block> BLOCKS = new LinkedHashMap<ResourceLocation, Block>();
    private static final Map<ResourceLocation, Pair<Block, Item.Properties>> BLOCK_ITEMS = new LinkedHashMap<ResourceLocation, Pair<Block, Item.Properties>>();
    private static final Map<CreativeModeTab, List<Block>> BLOCK_TABS = new LinkedHashMap<CreativeModeTab, List<Block>>();
    public static final Block CONJURED_LIGHT = HexBlocks.blockItem("conjured_light", new BlockConjuredLight(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_154654_).m_60953_(state -> 15).m_222994_().m_60922_((xva$0, xva$1, xva$2, xva$3) -> HexBlocks.never(xva$0, xva$1, xva$2, xva$3)).m_60966_().m_278166_(PushReaction.DESTROY).m_60910_().m_60960_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2)).m_60971_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2))), new Item.Properties());
    public static final Block CONJURED_BLOCK = HexBlocks.blockItem("conjured_block", new BlockConjured(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_60918_(SoundType.f_154654_).m_60953_(state -> 2).m_222994_().m_60922_((xva$0, xva$1, xva$2, xva$3) -> HexBlocks.never(xva$0, xva$1, xva$2, xva$3)).m_60966_().m_60955_().m_60960_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2)).m_60971_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2))), new Item.Properties());
    public static final BlockSlate SLATE = HexBlocks.blockNoItem("slate", new BlockSlate(HexBlocks.slateish().m_278166_(PushReaction.DESTROY)));
    public static final BlockEmptyImpetus IMPETUS_EMPTY = HexBlocks.blockItem("impetus/empty", new BlockEmptyImpetus(HexBlocks.slateish().m_278166_(PushReaction.BLOCK)));
    public static final BlockRightClickImpetus IMPETUS_RIGHTCLICK = HexBlocks.blockItem("impetus/rightclick", new BlockRightClickImpetus(HexBlocks.slateish().m_278166_(PushReaction.BLOCK).m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAbstractImpetus.ENERGIZED) != false ? 15 : 0)));
    public static final BlockLookingImpetus IMPETUS_LOOK = HexBlocks.blockItem("impetus/look", new BlockLookingImpetus(HexBlocks.slateish().m_278166_(PushReaction.BLOCK).m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAbstractImpetus.ENERGIZED) != false ? 15 : 0)));
    public static final BlockRedstoneImpetus IMPETUS_REDSTONE = HexBlocks.blockItem("impetus/redstone", new BlockRedstoneImpetus(HexBlocks.slateish().m_278166_(PushReaction.BLOCK).m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAbstractImpetus.ENERGIZED) != false ? 15 : 0)));
    public static final BlockEmptyDirectrix EMPTY_DIRECTRIX = HexBlocks.blockItem("directrix/empty", new BlockEmptyDirectrix(HexBlocks.slateish().m_278166_(PushReaction.BLOCK)));
    public static final BlockRedstoneDirectrix DIRECTRIX_REDSTONE = HexBlocks.blockItem("directrix/redstone", new BlockRedstoneDirectrix(HexBlocks.slateish().m_278166_(PushReaction.BLOCK)));
    public static final BlockBooleanDirectrix DIRECTRIX_BOOLEAN = HexBlocks.blockItem("directrix/boolean", new BlockBooleanDirectrix(HexBlocks.slateish().m_278166_(PushReaction.BLOCK)));
    public static final BlockAkashicRecord AKASHIC_RECORD = HexBlocks.blockItem("akashic_record", new BlockAkashicRecord(HexBlocks.akashicWoodyHard().m_60953_(bs -> 15)));
    public static final BlockAkashicBookshelf AKASHIC_BOOKSHELF = HexBlocks.blockItem("akashic_bookshelf", new BlockAkashicBookshelf(HexBlocks.akashicWoodyHard().m_60953_(bs -> (Boolean)bs.m_61143_((Property)BlockAkashicBookshelf.HAS_BOOKS) != false ? 4 : 0)));
    public static final BlockAkashicLigature AKASHIC_LIGATURE = HexBlocks.blockItem("akashic_connector", new BlockAkashicLigature(HexBlocks.akashicWoodyHard().m_60953_(bs -> 4)));
    public static final BlockQuenchedAllay QUENCHED_ALLAY = HexBlocks.blockItem("quenched_allay", new BlockQuenchedAllay(HexBlocks.quenched()));
    public static final BlockQuenchedAllay QUENCHED_ALLAY_TILES = HexBlocks.blockItem("quenched_allay_tiles", new BlockQuenchedAllay(HexBlocks.quenched()));
    public static final BlockQuenchedAllay QUENCHED_ALLAY_BRICKS = HexBlocks.blockItem("quenched_allay_bricks", new BlockQuenchedAllay(HexBlocks.quenched()));
    public static final BlockQuenchedAllay QUENCHED_ALLAY_BRICKS_SMALL = HexBlocks.blockItem("quenched_allay_bricks_small", new BlockQuenchedAllay(HexBlocks.quenched()));
    public static final Block SLATE_BLOCK = HexBlocks.blockItem("slate_block", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final Block SLATE_TILES = HexBlocks.blockItem("slate_tiles", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final Block SLATE_BRICKS = HexBlocks.blockItem("slate_bricks", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final Block SLATE_BRICKS_SMALL = HexBlocks.blockItem("slate_bricks_small", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final RotatedPillarBlock SLATE_PILLAR = HexBlocks.blockItem("slate_pillar", new RotatedPillarBlock(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final SandBlock AMETHYST_DUST_BLOCK = HexBlocks.blockItem("amethyst_dust_block", new SandBlock(-5009677, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49992_).m_284180_(MapColor.f_283889_).m_60978_(0.5f).m_60918_(SoundType.f_56746_)));
    public static final AmethystBlock AMETHYST_TILES = HexBlocks.blockItem("amethyst_tiles", new AmethystBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final AmethystBlock AMETHYST_BRICKS = HexBlocks.blockItem("amethyst_bricks", new AmethystBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final AmethystBlock AMETHYST_BRICKS_SMALL = HexBlocks.blockItem("amethyst_bricks_small", new AmethystBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final BlockAmethystDirectional AMETHYST_PILLAR = HexBlocks.blockItem("amethyst_pillar", new BlockAmethystDirectional(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_)));
    public static final Block SLATE_AMETHYST_TILES = HexBlocks.blockItem("slate_amethyst_tiles", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final Block SLATE_AMETHYST_BRICKS = HexBlocks.blockItem("slate_amethyst_bricks", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final Block SLATE_AMETHYST_BRICKS_SMALL = HexBlocks.blockItem("slate_amethyst_bricks_small", new Block(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final RotatedPillarBlock SLATE_AMETHYST_PILLAR = HexBlocks.blockItem("slate_amethyst_pillar", new RotatedPillarBlock(HexBlocks.slateish().m_60913_(2.0f, 4.0f)));
    public static final Block SCROLL_PAPER = HexBlocks.blockItem("scroll_paper", new BlockFlammable(HexBlocks.papery(MapColor.f_283919_), 100, 60));
    public static final Block ANCIENT_SCROLL_PAPER = HexBlocks.blockItem("ancient_scroll_paper", new BlockFlammable(HexBlocks.papery(MapColor.f_283895_), 100, 60));
    public static final Block SCROLL_PAPER_LANTERN = HexBlocks.blockItem("scroll_paper_lantern", new BlockFlammable(HexBlocks.papery(MapColor.f_283919_).m_60953_($ -> 15), 100, 60));
    public static final Block ANCIENT_SCROLL_PAPER_LANTERN = HexBlocks.blockItem("ancient_scroll_paper_lantern", new BlockFlammable(HexBlocks.papery(MapColor.f_283895_).m_60953_($ -> 12), 100, 60));
    public static final BlockSconce SCONCE = HexBlocks.blockItem("amethyst_sconce", new BlockSconce(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283889_).m_60918_(SoundType.f_154654_).m_60978_(1.0f).m_60953_($ -> 15)), HexItems.props().m_41497_(Rarity.RARE));
    public static final BlockAkashicLog EDIFIED_LOG = HexBlocks.blockItem("edified_log", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog EDIFIED_LOG_AMETHYST = HexBlocks.blockItem("edified_log_amethyst", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog EDIFIED_LOG_AVENTURINE = HexBlocks.blockItem("edified_log_aventurine", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog EDIFIED_LOG_CITRINE = HexBlocks.blockItem("edified_log_citrine", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog EDIFIED_LOG_PURPLE = HexBlocks.blockItem("edified_log_purple", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog STRIPPED_EDIFIED_LOG = HexBlocks.blockItem("stripped_edified_log", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog EDIFIED_WOOD = HexBlocks.blockItem("edified_wood", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final BlockAkashicLog STRIPPED_EDIFIED_WOOD = HexBlocks.blockItem("stripped_edified_wood", new BlockAkashicLog(HexBlocks.edifiedWoody()));
    public static final Block EDIFIED_PLANKS = HexBlocks.blockItem("edified_planks", new BlockFlammable(HexBlocks.edifiedWoody(), 20, 5));
    public static final Block EDIFIED_PANEL = HexBlocks.blockItem("edified_panel", new BlockFlammable(HexBlocks.edifiedWoody(), 20, 5));
    public static final Block EDIFIED_TILE = HexBlocks.blockItem("edified_tile", new BlockFlammable(HexBlocks.edifiedWoody(), 20, 5));
    public static final DoorBlock EDIFIED_DOOR = HexBlocks.blockItem("edified_door", new BlockHexDoor(HexBlocks.edifiedWoody().m_60955_()));
    public static final TrapDoorBlock EDIFIED_TRAPDOOR = HexBlocks.blockItem("edified_trapdoor", new BlockHexTrapdoor(HexBlocks.edifiedWoody().m_60955_()));
    public static final StairBlock EDIFIED_STAIRS = HexBlocks.blockItem("edified_stairs", new BlockHexStairs(EDIFIED_PLANKS.m_49966_(), HexBlocks.edifiedWoody().m_60955_()));
    public static final FenceBlock EDIFIED_FENCE = HexBlocks.blockItem("edified_fence", new BlockHexFence(HexBlocks.edifiedWoody().m_60955_()));
    public static final FenceGateBlock EDIFIED_FENCE_GATE = HexBlocks.blockItem("edified_fence_gate", new BlockHexFenceGate(HexBlocks.edifiedWoody().m_60955_()));
    public static final SlabBlock EDIFIED_SLAB = HexBlocks.blockItem("edified_slab", new BlockHexSlab(HexBlocks.edifiedWoody().m_60955_()));
    public static final ButtonBlock EDIFIED_BUTTON = HexBlocks.blockItem("edified_button", new BlockHexWoodButton(HexBlocks.edifiedWoody().m_60955_().m_60910_()));
    public static final PressurePlateBlock EDIFIED_PRESSURE_PLATE = HexBlocks.blockItem("edified_pressure_plate", new BlockHexPressurePlate(PressurePlateBlock.Sensitivity.EVERYTHING, HexBlocks.edifiedWoody().m_60955_().m_60910_()));
    public static final BlockAkashicLeaves AMETHYST_EDIFIED_LEAVES = HexBlocks.blockItem("amethyst_edified_leaves", new BlockAkashicLeaves(HexBlocks.leaves(MapColor.f_283889_)));
    public static final BlockAkashicLeaves AVENTURINE_EDIFIED_LEAVES = HexBlocks.blockItem("aventurine_edified_leaves", new BlockAkashicLeaves(HexBlocks.leaves(MapColor.f_283743_)));
    public static final BlockAkashicLeaves CITRINE_EDIFIED_LEAVES = HexBlocks.blockItem("citrine_edified_leaves", new BlockAkashicLeaves(HexBlocks.leaves(MapColor.f_283832_)));

    public static void registerBlocks(BiConsumer<Block, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Block> e : BLOCKS.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    public static void registerBlockItems(BiConsumer<Item, ResourceLocation> r) {
        for (Map.Entry<ResourceLocation, Pair<Block, Item.Properties>> e : BLOCK_ITEMS.entrySet()) {
            r.accept((Item)new BlockItem((Block)e.getValue().getFirst(), (Item.Properties)e.getValue().getSecond()), e.getKey());
        }
    }

    public static void registerBlockCreativeTab(Consumer<Block> r, CreativeModeTab tab) {
        for (Block block : BLOCK_TABS.getOrDefault(tab, List.of())) {
            r.accept(block);
        }
    }

    private static BlockBehaviour.Properties slateish() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152559_).m_60913_(4.0f, 4.0f);
    }

    private static BlockBehaviour.Properties papery(MapColor color) {
        return BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60918_(SoundType.f_56740_).m_60966_().m_278183_().m_278166_(PushReaction.DESTROY);
    }

    private static BlockBehaviour.Properties akashicWoodyHard() {
        return HexBlocks.woodyHard(MapColor.f_283889_);
    }

    private static BlockBehaviour.Properties woodyHard(MapColor color) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_284180_(color).m_60918_(SoundType.f_56736_).m_60913_(3.0f, 4.0f);
    }

    private static BlockBehaviour.Properties edifiedWoody() {
        return HexBlocks.woody(MapColor.f_283889_);
    }

    private static BlockBehaviour.Properties woody(MapColor color) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49999_).m_284180_(color).m_60918_(SoundType.f_56736_).m_60978_(2.0f);
    }

    private static BlockBehaviour.Properties leaves(MapColor color) {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50050_).m_60978_(0.2f).m_60977_().m_60918_(SoundType.f_56740_).m_60955_().m_60922_((bs, level, pos, type) -> type == EntityType.f_20505_ || type == EntityType.f_20508_).m_60960_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2)).m_60971_((xva$0, xva$1, xva$2) -> HexBlocks.never(xva$0, xva$1, xva$2));
    }

    private static BlockBehaviour.Properties quenched() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_152490_).m_60953_($ -> 4).m_60955_();
    }

    private static boolean never(Object ... args) {
        return false;
    }

    private static <T extends Block> T blockNoItem(String name, T block) {
        Block old = BLOCKS.put(HexAPI.modLoc(name), block);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        return block;
    }

    private static <T extends Block> T blockItem(String name, T block) {
        return HexBlocks.blockItem(name, block, HexItems.props(), HexCreativeTabs.HEX);
    }

    private static <T extends Block> T blockItem(String name, T block, @Nullable CreativeModeTab tab) {
        return HexBlocks.blockItem(name, block, HexItems.props(), tab);
    }

    private static <T extends Block> T blockItem(String name, T block, Item.Properties props) {
        return HexBlocks.blockItem(name, block, props, HexCreativeTabs.HEX);
    }

    private static <T extends Block> T blockItem(String name, T block, Item.Properties props, @Nullable CreativeModeTab tab) {
        HexBlocks.blockNoItem(name, block);
        Pair<Block, Item.Properties> old = BLOCK_ITEMS.put(HexAPI.modLoc(name), (Pair<Block, Item.Properties>)new Pair(block, (Object)props));
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + name);
        }
        if (tab != null) {
            BLOCK_TABS.computeIfAbsent(tab, t -> new ArrayList()).add(block);
        }
        return block;
    }
}

