/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.casting.actions.spells;

import at.petrak.hexcasting.api.casting.OperatorUtils;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.castables.SpellAction;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpPotionEffect;", "Lat/petrak/hexcasting/api/casting/castables/SpellAction;", "effect", "Lnet/minecraft/world/effect/MobEffect;", "baseCost", "", "allowPotency", "", "potencyCubic", "(Lnet/minecraft/world/effect/MobEffect;JZZ)V", "getAllowPotency", "()Z", "argc", "", "getArgc", "()I", "getBaseCost", "()J", "getEffect", "()Lnet/minecraft/world/effect/MobEffect;", "getPotencyCubic", "execute", "Lat/petrak/hexcasting/api/casting/castables/SpellAction$Result;", "args", "", "Lat/petrak/hexcasting/api/casting/iota/Iota;", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "Spell", "hexcasting-forge-1.20.1"})
public final class OpPotionEffect
implements SpellAction {
    @NotNull
    private final MobEffect effect;
    private final long baseCost;
    private final boolean allowPotency;
    private final boolean potencyCubic;

    public OpPotionEffect(@NotNull MobEffect effect, long baseCost, boolean allowPotency, boolean potencyCubic) {
        Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
        this.effect = effect;
        this.baseCost = baseCost;
        this.allowPotency = allowPotency;
        this.potencyCubic = potencyCubic;
    }

    @NotNull
    public final MobEffect getEffect() {
        return this.effect;
    }

    public final long getBaseCost() {
        return this.baseCost;
    }

    public final boolean getAllowPotency() {
        return this.allowPotency;
    }

    public final boolean getPotencyCubic() {
        return this.potencyCubic;
    }

    @Override
    public int getArgc() {
        return this.allowPotency ? 3 : 2;
    }

    @Override
    @NotNull
    public SpellAction.Result execute(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        LivingEntity target = OperatorUtils.getLivingEntityButNotArmorStand(args, 0, this.getArgc());
        double duration = OperatorUtils.getPositiveDouble(args, 1, this.getArgc());
        double potency = this.allowPotency ? OperatorUtils.getDoubleBetween(args, 2, 1.0, 127.0, this.getArgc()) : 1.0;
        env.assertEntityInRange((Entity)target);
        double cost = (double)this.baseCost * duration * (this.potencyCubic ? potency * potency * potency : potency * potency);
        RenderedSpell renderedSpell = new Spell(this.effect, target, duration, potency);
        long l = (long)cost;
        Vec3 vec3 = target.m_20182_().m_82520_(0.0, (double)target.m_20192_() / 2.0, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"target.position().add(0.\u2026get.eyeHeight / 2.0, 0.0)");
        return new SpellAction.Result(renderedSpell, l, CollectionsKt.listOf((Object)ParticleSpray.Companion.cloud$default(ParticleSpray.Companion, vec3, 1.0, 0, 4, null)), 0L, 8, null);
    }

    @Override
    public boolean hasCastingSound(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.hasCastingSound(this, ctx);
    }

    @Override
    public boolean awardsCastingStat(@NotNull CastingEnvironment ctx) {
        return SpellAction.DefaultImpls.awardsCastingStat(this, ctx);
    }

    @Override
    @NotNull
    public SpellAction.Result executeWithUserdata(@NotNull List<? extends Iota> args, @NotNull CastingEnvironment env, @NotNull CompoundTag userData) {
        return SpellAction.DefaultImpls.executeWithUserdata(this, args, env, userData);
    }

    @Override
    @NotNull
    public OperationResult operate(@NotNull CastingEnvironment env, @NotNull CastingImage image, @NotNull SpellContinuation continuation) {
        return SpellAction.DefaultImpls.operate(this, env, image, continuation);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/common/casting/actions/spells/OpPotionEffect$Spell;", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "effect", "Lnet/minecraft/world/effect/MobEffect;", "target", "Lnet/minecraft/world/entity/LivingEntity;", "duration", "", "potency", "(Lnet/minecraft/world/effect/MobEffect;Lnet/minecraft/world/entity/LivingEntity;DD)V", "getDuration", "()D", "getEffect", "()Lnet/minecraft/world/effect/MobEffect;", "getPotency", "getTarget", "()Lnet/minecraft/world/entity/LivingEntity;", "cast", "", "env", "Lat/petrak/hexcasting/api/casting/eval/CastingEnvironment;", "hexcasting-forge-1.20.1"})
    private static final class Spell
    implements RenderedSpell {
        @NotNull
        private final MobEffect effect;
        @NotNull
        private final LivingEntity target;
        private final double duration;
        private final double potency;

        public Spell(@NotNull MobEffect effect, @NotNull LivingEntity target, double duration, double potency) {
            Intrinsics.checkNotNullParameter((Object)effect, (String)"effect");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.effect = effect;
            this.target = target;
            this.duration = duration;
            this.potency = potency;
        }

        @NotNull
        public final MobEffect getEffect() {
            return this.effect;
        }

        @NotNull
        public final LivingEntity getTarget() {
            return this.target;
        }

        public final double getDuration() {
            return this.duration;
        }

        public final double getPotency() {
            return this.potency;
        }

        @Override
        public void cast(@NotNull CastingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            if (this.duration > 0.05) {
                MobEffectInstance effectInst = new MobEffectInstance(this.effect, (int)(this.duration * (double)20), (int)this.potency - 1);
                this.target.m_7292_(effectInst);
            }
        }

        @Override
        @Nullable
        public CastingImage cast(@NotNull CastingEnvironment env, @NotNull CastingImage image) {
            return RenderedSpell.DefaultImpls.cast(this, env, image);
        }
    }
}

