/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.client.render;

import at.petrak.hexcasting.client.render.HexPatternLike;
import at.petrak.hexcasting.client.render.HexPatternPoints;
import at.petrak.hexcasting.client.render.PatternSettings;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec2;

public class PatternTextureManager {
    public static boolean useTextures = true;
    public static int repaintIndex = 0;
    private static final ConcurrentMap<String, Map<String, ResourceLocation>> patternTexturesToAdd = new ConcurrentHashMap<String, Map<String, ResourceLocation>>();
    private static final Set<String> inProgressPatterns = new HashSet<String>();
    private static final ExecutorService executor = new ThreadPoolExecutor(0, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
    private static final HashMap<String, Map<String, ResourceLocation>> patternTextures = new HashMap();

    public static Optional<Map<String, ResourceLocation>> getTextures(HexPatternLike patternlike, PatternSettings patSets, double seed, int resPerUnit) {
        String patCacheKey = patSets.getCacheKey(patternlike, seed) + "_" + resPerUnit;
        if (patternTexturesToAdd.containsKey(patCacheKey)) {
            Map patternTexture = (Map)patternTexturesToAdd.remove(patCacheKey);
            Map<String, ResourceLocation> oldPatternTexture = patternTextures.put(patCacheKey, patternTexture);
            inProgressPatterns.remove(patCacheKey);
            if (oldPatternTexture != null) {
                for (ResourceLocation oldPatternTextureSingle : oldPatternTexture.values()) {
                    Minecraft.m_91087_().m_91097_().m_118506_(oldPatternTextureSingle).close();
                }
            }
            return Optional.empty();
        }
        if (patternTextures.containsKey(patCacheKey)) {
            return Optional.of(patternTextures.get(patCacheKey));
        }
        if (!inProgressPatterns.contains(patCacheKey)) {
            inProgressPatterns.add(patCacheKey);
            executor.submit(() -> {
                Map<String, DynamicTexture> slowTextures = PatternTextureManager.createTextures(patternlike, patSets, seed, resPerUnit);
                Minecraft.m_91087_().execute(() -> PatternTextureManager.registerTextures(patCacheKey, slowTextures));
            });
        }
        return Optional.empty();
    }

    private static Map<String, DynamicTexture> createTextures(HexPatternLike patternlike, PatternSettings patSets, double seed, int resPerUnit) {
        HexPatternPoints staticPoints = HexPatternPoints.getStaticPoints(patternlike, patSets, seed);
        List<Vec2> zappyRenderSpace = staticPoints.scaleVecs((List<Vec2>)staticPoints.zappyPoints);
        HashMap<String, DynamicTexture> patTexts = new HashMap<String, DynamicTexture>();
        NativeImage innerLines = PatternTextureManager.drawLines(zappyRenderSpace, staticPoints, (float)patSets.getInnerWidth(staticPoints.finalScale), resPerUnit);
        patTexts.put("inner", new DynamicTexture(innerLines));
        NativeImage outerLines = PatternTextureManager.drawLines(zappyRenderSpace, staticPoints, (float)patSets.getOuterWidth(staticPoints.finalScale), resPerUnit);
        patTexts.put("outer", new DynamicTexture(outerLines));
        return patTexts;
    }

    private static Map<String, ResourceLocation> registerTextures(String patTextureKeyBase, Map<String, DynamicTexture> dynamicTextures) {
        HashMap<String, ResourceLocation> resLocs = new HashMap<String, ResourceLocation>();
        for (Map.Entry<String, DynamicTexture> textureEntry : dynamicTextures.entrySet()) {
            String name = "hex_pattern_texture_" + patTextureKeyBase + "_" + textureEntry.getKey() + "_" + repaintIndex + ".png";
            ResourceLocation resourceLocation = Minecraft.m_91087_().m_91097_().m_118490_(name, textureEntry.getValue());
            resLocs.put(textureEntry.getKey(), resourceLocation);
        }
        patternTexturesToAdd.put(patTextureKeyBase, resLocs);
        return resLocs;
    }

    private static NativeImage drawLines(List<Vec2> points, HexPatternPoints staticPoints, float unscaledLineWidth, int resPerUnit) {
        BufferedImage img = new BufferedImage((int)(staticPoints.fullWidth * (double)resPerUnit), (int)(staticPoints.fullHeight * (double)resPerUnit), 2);
        Graphics2D g2d = img.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(new Color(-1));
        g2d.setStroke(new BasicStroke(unscaledLineWidth * (float)resPerUnit, 1, 1));
        for (int i = 0; i < points.size() - 1; ++i) {
            Tuple<Integer, Integer> pointFrom = PatternTextureManager.getTextureCoordinates(points.get(i), staticPoints, resPerUnit);
            Tuple<Integer, Integer> pointTo = PatternTextureManager.getTextureCoordinates(points.get(i + 1), staticPoints, resPerUnit);
            g2d.drawLine((Integer)pointFrom.m_14418_(), (Integer)pointFrom.m_14419_(), (Integer)pointTo.m_14418_(), (Integer)pointTo.m_14419_());
        }
        g2d.dispose();
        NativeImage nativeImage = new NativeImage(img.getWidth(), img.getHeight(), true);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                nativeImage.m_84988_(x, y, img.getRGB(x, y));
            }
        }
        return nativeImage;
    }

    private static Tuple<Integer, Integer> getTextureCoordinates(Vec2 point, HexPatternPoints staticPoints, int resPerUnit) {
        int x = (int)(point.f_82470_ * (float)resPerUnit);
        int y = (int)(point.f_82471_ * (float)resPerUnit);
        return new Tuple((Object)x, (Object)y);
    }

    private static void drawHexagon(Graphics2D g2d, int x, int y, int radius) {
        int fracOfCircle = 6;
        Polygon hexagon = new Polygon();
        for (int i = 0; i < fracOfCircle; ++i) {
            double theta = (double)i / (double)fracOfCircle * Math.PI * 2.0;
            int hx = (int)((double)x + Math.cos(theta) * (double)radius);
            int hy = (int)((double)y + Math.sin(theta) * (double)radius);
            hexagon.addPoint(hx, hy);
        }
        g2d.fill(hexagon);
    }

    public static void repaint() {
        ++repaintIndex;
        patternTexturesToAdd.clear();
        patternTextures.clear();
    }
}

