/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval.sideeffects;

import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.RenderedSpell;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.CastingVM;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.mod.HexStatistics;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.items.pigment.ItemDyePigment;
import at.petrak.hexcasting.common.lib.HexItems;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u0007\b\t\n\u000bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H&\u0082\u0001\u0005\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect;", "", "()V", "performEffect", "", "harness", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;", "AttemptSpell", "ConsumeMedia", "DoMishap", "Particles", "RequiredEnlightenment", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$AttemptSpell;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$ConsumeMedia;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$DoMishap;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$Particles;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$RequiredEnlightenment;", "hexcasting-forge-1.20.1"})
public abstract class OperatorSideEffect {
    private OperatorSideEffect() {
    }

    public abstract void performEffect(@NotNull CastingVM var1);

    public /* synthetic */ OperatorSideEffect(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$RequiredEnlightenment;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect;", "awardStat", "", "(Z)V", "getAwardStat", "()Z", "component1", "copy", "equals", "other", "", "hashCode", "", "performEffect", "", "harness", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;", "toString", "", "hexcasting-forge-1.20.1"})
    public static final class RequiredEnlightenment
    extends OperatorSideEffect {
        private final boolean awardStat;

        public RequiredEnlightenment(boolean awardStat) {
            super(null);
            this.awardStat = awardStat;
        }

        public final boolean getAwardStat() {
            return this.awardStat;
        }

        @Override
        public void performEffect(@NotNull CastingVM harness) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)harness, (String)"harness");
                LivingEntity livingEntity = harness.getEnv().getCastingEntity();
                if (livingEntity == null) break block0;
                livingEntity.m_213846_((Component)HexUtils.getAsTranslatedComponent("hexcasting.message.cant_great_spell"));
            }
        }

        public final boolean component1() {
            return this.awardStat;
        }

        @NotNull
        public final RequiredEnlightenment copy(boolean awardStat) {
            return new RequiredEnlightenment(awardStat);
        }

        public static /* synthetic */ RequiredEnlightenment copy$default(RequiredEnlightenment requiredEnlightenment, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = requiredEnlightenment.awardStat;
            }
            return requiredEnlightenment.copy(bl);
        }

        @NotNull
        public String toString() {
            return "RequiredEnlightenment(awardStat=" + this.awardStat + ")";
        }

        public int hashCode() {
            int n = this.awardStat ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RequiredEnlightenment)) {
                return false;
            }
            RequiredEnlightenment requiredEnlightenment = (RequiredEnlightenment)other;
            return this.awardStat == requiredEnlightenment.awardStat;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$AttemptSpell;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect;", "spell", "Lat/petrak/hexcasting/api/casting/RenderedSpell;", "hasCastingSound", "", "awardStat", "(Lat/petrak/hexcasting/api/casting/RenderedSpell;ZZ)V", "getAwardStat", "()Z", "getHasCastingSound", "getSpell", "()Lat/petrak/hexcasting/api/casting/RenderedSpell;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "performEffect", "", "harness", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;", "toString", "", "hexcasting-forge-1.20.1"})
    public static final class AttemptSpell
    extends OperatorSideEffect {
        @NotNull
        private final RenderedSpell spell;
        private final boolean hasCastingSound;
        private final boolean awardStat;

        public AttemptSpell(@NotNull RenderedSpell spell, boolean hasCastingSound, boolean awardStat) {
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            super(null);
            this.spell = spell;
            this.hasCastingSound = hasCastingSound;
            this.awardStat = awardStat;
        }

        public /* synthetic */ AttemptSpell(RenderedSpell renderedSpell, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            this(renderedSpell, bl, bl2);
        }

        @NotNull
        public final RenderedSpell getSpell() {
            return this.spell;
        }

        public final boolean getHasCastingSound() {
            return this.hasCastingSound;
        }

        public final boolean getAwardStat() {
            return this.awardStat;
        }

        @Override
        public void performEffect(@NotNull CastingVM harness) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)harness, (String)"harness");
                CastingImage castingImage = this.spell.cast(harness.getEnv(), harness.getImage());
                if (castingImage != null) {
                    CastingImage it = castingImage;
                    boolean bl = false;
                    harness.setImage(it);
                }
                if (!this.awardStat) break block2;
                LivingEntity livingEntity = harness.getEnv().getCastingEntity();
                ServerPlayer serverPlayer = livingEntity instanceof ServerPlayer ? (ServerPlayer)livingEntity : null;
                if (serverPlayer != null) {
                    serverPlayer.m_36220_(HexStatistics.SPELLS_CAST);
                }
            }
        }

        @NotNull
        public final RenderedSpell component1() {
            return this.spell;
        }

        public final boolean component2() {
            return this.hasCastingSound;
        }

        public final boolean component3() {
            return this.awardStat;
        }

        @NotNull
        public final AttemptSpell copy(@NotNull RenderedSpell spell, boolean hasCastingSound, boolean awardStat) {
            Intrinsics.checkNotNullParameter((Object)spell, (String)"spell");
            return new AttemptSpell(spell, hasCastingSound, awardStat);
        }

        public static /* synthetic */ AttemptSpell copy$default(AttemptSpell attemptSpell, RenderedSpell renderedSpell, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                renderedSpell = attemptSpell.spell;
            }
            if ((n & 2) != 0) {
                bl = attemptSpell.hasCastingSound;
            }
            if ((n & 4) != 0) {
                bl2 = attemptSpell.awardStat;
            }
            return attemptSpell.copy(renderedSpell, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "AttemptSpell(spell=" + this.spell + ", hasCastingSound=" + this.hasCastingSound + ", awardStat=" + this.awardStat + ")";
        }

        public int hashCode() {
            int result = this.spell.hashCode();
            int n = this.hasCastingSound ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.awardStat ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AttemptSpell)) {
                return false;
            }
            AttemptSpell attemptSpell = (AttemptSpell)other;
            if (!Intrinsics.areEqual((Object)this.spell, (Object)attemptSpell.spell)) {
                return false;
            }
            if (this.hasCastingSound != attemptSpell.hasCastingSound) {
                return false;
            }
            return this.awardStat == attemptSpell.awardStat;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$ConsumeMedia;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect;", "amount", "", "(J)V", "getAmount", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "performEffect", "", "harness", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;", "toString", "", "hexcasting-forge-1.20.1"})
    public static final class ConsumeMedia
    extends OperatorSideEffect {
        private final long amount;

        public ConsumeMedia(long amount) {
            super(null);
            this.amount = amount;
        }

        public final long getAmount() {
            return this.amount;
        }

        @Override
        public void performEffect(@NotNull CastingVM harness) {
            Intrinsics.checkNotNullParameter((Object)harness, (String)"harness");
            harness.getEnv().extractMedia(this.amount, false);
        }

        public final long component1() {
            return this.amount;
        }

        @NotNull
        public final ConsumeMedia copy(long amount) {
            return new ConsumeMedia(amount);
        }

        public static /* synthetic */ ConsumeMedia copy$default(ConsumeMedia consumeMedia, long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = consumeMedia.amount;
            }
            return consumeMedia.copy(l);
        }

        @NotNull
        public String toString() {
            return "ConsumeMedia(amount=" + this.amount + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.amount);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ConsumeMedia)) {
                return false;
            }
            ConsumeMedia consumeMedia = (ConsumeMedia)other;
            return this.amount == consumeMedia.amount;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$Particles;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect;", "spray", "Lat/petrak/hexcasting/api/casting/ParticleSpray;", "(Lat/petrak/hexcasting/api/casting/ParticleSpray;)V", "getSpray", "()Lat/petrak/hexcasting/api/casting/ParticleSpray;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "performEffect", "", "harness", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;", "toString", "", "hexcasting-forge-1.20.1"})
    public static final class Particles
    extends OperatorSideEffect {
        @NotNull
        private final ParticleSpray spray;

        public Particles(@NotNull ParticleSpray spray) {
            Intrinsics.checkNotNullParameter((Object)spray, (String)"spray");
            super(null);
            this.spray = spray;
        }

        @NotNull
        public final ParticleSpray getSpray() {
            return this.spray;
        }

        @Override
        public void performEffect(@NotNull CastingVM harness) {
            Intrinsics.checkNotNullParameter((Object)harness, (String)"harness");
            harness.getEnv().produceParticles(this.spray, harness.getEnv().getPigment());
        }

        @NotNull
        public final ParticleSpray component1() {
            return this.spray;
        }

        @NotNull
        public final Particles copy(@NotNull ParticleSpray spray) {
            Intrinsics.checkNotNullParameter((Object)spray, (String)"spray");
            return new Particles(spray);
        }

        public static /* synthetic */ Particles copy$default(Particles particles, ParticleSpray particleSpray, int n, Object object) {
            if ((n & 1) != 0) {
                particleSpray = particles.spray;
            }
            return particles.copy(particleSpray);
        }

        @NotNull
        public String toString() {
            return "Particles(spray=" + this.spray + ")";
        }

        public int hashCode() {
            return this.spray.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Particles)) {
                return false;
            }
            Particles particles = (Particles)other;
            return Intrinsics.areEqual((Object)this.spray, (Object)particles.spray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect$DoMishap;", "Lat/petrak/hexcasting/api/casting/eval/sideeffects/OperatorSideEffect;", "mishap", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap;", "errorCtx", "Lat/petrak/hexcasting/api/casting/mishaps/Mishap$Context;", "(Lat/petrak/hexcasting/api/casting/mishaps/Mishap;Lat/petrak/hexcasting/api/casting/mishaps/Mishap$Context;)V", "getErrorCtx", "()Lat/petrak/hexcasting/api/casting/mishaps/Mishap$Context;", "getMishap", "()Lat/petrak/hexcasting/api/casting/mishaps/Mishap;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "performEffect", "", "harness", "Lat/petrak/hexcasting/api/casting/eval/vm/CastingVM;", "toString", "", "hexcasting-forge-1.20.1"})
    public static final class DoMishap
    extends OperatorSideEffect {
        @NotNull
        private final Mishap mishap;
        @NotNull
        private final Mishap.Context errorCtx;

        public DoMishap(@NotNull Mishap mishap, @NotNull Mishap.Context errorCtx) {
            Intrinsics.checkNotNullParameter((Object)mishap, (String)"mishap");
            Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
            super(null);
            this.mishap = mishap;
            this.errorCtx = errorCtx;
        }

        @NotNull
        public final Mishap getMishap() {
            return this.mishap;
        }

        @NotNull
        public final Mishap.Context getErrorCtx() {
            return this.errorCtx;
        }

        @Override
        public void performEffect(@NotNull CastingVM harness) {
            Intrinsics.checkNotNullParameter((Object)harness, (String)"harness");
            ParticleSpray spray = this.mishap.particleSpray(harness.getEnv());
            FrozenPigment color = this.mishap.accentColor(harness.getEnv(), this.errorCtx);
            ServerLevel serverLevel = harness.getEnv().getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"harness.env.world");
            spray.sprayParticles(serverLevel, color);
            ServerLevel serverLevel2 = harness.getEnv().getWorld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel2, (String)"harness.env.world");
            ItemDyePigment itemDyePigment = HexItems.DYE_PIGMENTS.get(DyeColor.RED);
            Intrinsics.checkNotNull((Object)itemDyePigment);
            spray.sprayParticles(serverLevel2, new FrozenPigment(new ItemStack((ItemLike)itemDyePigment), Util.f_137441_));
            harness.setImage(CastingImage.copy$default(harness.getImage(), this.mishap.executeReturnStack(harness.getEnv(), this.errorCtx, CollectionsKt.toMutableList((Collection)harness.getImage().getStack())), 0, null, false, 0L, null, 62, null));
        }

        @NotNull
        public final Mishap component1() {
            return this.mishap;
        }

        @NotNull
        public final Mishap.Context component2() {
            return this.errorCtx;
        }

        @NotNull
        public final DoMishap copy(@NotNull Mishap mishap, @NotNull Mishap.Context errorCtx) {
            Intrinsics.checkNotNullParameter((Object)mishap, (String)"mishap");
            Intrinsics.checkNotNullParameter((Object)errorCtx, (String)"errorCtx");
            return new DoMishap(mishap, errorCtx);
        }

        public static /* synthetic */ DoMishap copy$default(DoMishap doMishap, Mishap mishap, Mishap.Context context, int n, Object object) {
            if ((n & 1) != 0) {
                mishap = doMishap.mishap;
            }
            if ((n & 2) != 0) {
                context = doMishap.errorCtx;
            }
            return doMishap.copy(mishap, context);
        }

        @NotNull
        public String toString() {
            return "DoMishap(mishap=" + this.mishap + ", errorCtx=" + this.errorCtx + ")";
        }

        public int hashCode() {
            int result = this.mishap.hashCode();
            result = result * 31 + this.errorCtx.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DoMishap)) {
                return false;
            }
            DoMishap doMishap = (DoMishap)other;
            if (!Intrinsics.areEqual((Object)this.mishap, (Object)doMishap.mishap)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.errorCtx, (Object)doMishap.errorCtx);
        }
    }
}

