/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.advancements;

import at.petrak.hexcasting.api.mod.HexConfig;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class OvercastTrigger
extends SimpleCriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("hexcasting", "overcast");
    private static final String TAG_MEDIA_GENERATED = "media_generated";
    private static final String TAG_HEALTH_USED = "health_used";
    private static final String TAG_HEALTH_LEFT = "mojang_i_am_begging_and_crying_please_add_an_entity_health_criterion";

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected Instance createInstance(JsonObject json, ContextAwarePredicate predicate, DeserializationContext pContext) {
        return new Instance(predicate, MinMaxBounds.Ints.m_55373_((JsonElement)json.get(TAG_MEDIA_GENERATED)), MinMaxBounds.Doubles.m_154791_((JsonElement)json.get(TAG_HEALTH_USED)), MinMaxBounds.Doubles.m_154791_((JsonElement)json.get(TAG_HEALTH_LEFT)));
    }

    public void trigger(ServerPlayer player, int mediaGenerated) {
        super.m_66234_(player, inst -> {
            double mediaToHealth = HexConfig.common().mediaToHealthRate();
            double healthUsed = (double)mediaGenerated / mediaToHealth;
            return inst.test(mediaGenerated, healthUsed / (double)player.m_21233_(), player.m_21223_());
        });
    }

    public static class Instance
    extends AbstractCriterionTriggerInstance {
        protected final MinMaxBounds.Ints mediaGenerated;
        protected final MinMaxBounds.Doubles healthUsed;
        protected final MinMaxBounds.Doubles healthLeft;

        public Instance(ContextAwarePredicate predicate, MinMaxBounds.Ints mediaGenerated, MinMaxBounds.Doubles healthUsed, MinMaxBounds.Doubles healthLeft) {
            super(ID, predicate);
            this.mediaGenerated = mediaGenerated;
            this.healthUsed = healthUsed;
            this.healthLeft = healthLeft;
        }

        public ResourceLocation m_7294_() {
            return ID;
        }

        public JsonObject m_7683_(SerializationContext ctx) {
            JsonObject json = super.m_7683_(ctx);
            if (!this.mediaGenerated.m_55327_()) {
                json.add(OvercastTrigger.TAG_MEDIA_GENERATED, this.mediaGenerated.m_55328_());
            }
            if (!this.healthUsed.m_55327_()) {
                json.add(OvercastTrigger.TAG_HEALTH_USED, this.healthUsed.m_55328_());
            }
            if (!this.healthLeft.m_55327_()) {
                json.add(OvercastTrigger.TAG_HEALTH_LEFT, this.healthLeft.m_55328_());
            }
            return json;
        }

        private boolean test(int mediaGeneratedIn, double healthUsedIn, float healthLeftIn) {
            return this.mediaGenerated.m_55390_(mediaGeneratedIn) && this.healthUsed.m_154810_(healthUsedIn) && this.healthLeft.m_154810_((double)healthLeftIn);
        }
    }
}

