/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.formations.Formations;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.phys.AABB;

public class Template {
    public static final int MAX_NAME_LENGTH = 50;
    private final AABB area;
    private final String name;

    public static boolean isValidName(String name) {
        return (name = name.trim()).length() <= 50 && name.matches("[a-zA-Z0-9_/-]+") && name.charAt(0) != '/' && name.charAt(name.length() - 1) != '/';
    }

    public static Template create(AABB area, String name) {
        return new Template(area, name);
    }

    public static Template load(CompoundTag data) {
        AABB area = new AABB(data.m_128459_("areaMinX"), data.m_128459_("areaMinY"), data.m_128459_("areaMinZ"), data.m_128459_("areaMaxX"), data.m_128459_("areaMaxY"), data.m_128459_("areaMaxZ"));
        String name = data.m_128461_("name");
        return Template.create(area, name);
    }

    public static Template load(FriendlyByteBuf buffer) {
        AABB area = new AABB(buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        String name = buffer.m_130136_(50);
        return Template.create(area, name);
    }

    private Template(AABB area, String name) {
        this.area = area;
        this.name = name;
    }

    public AABB getArea() {
        return this.area;
    }

    public String getName() {
        return this.name;
    }

    public boolean recordAndExport(Level level, Path output) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int x = (int)this.area.f_82288_;
        while ((double)x < this.area.f_82291_) {
            int y = (int)this.area.f_82289_;
            while ((double)y < this.area.f_82292_) {
                int z = (int)this.area.f_82290_;
                while ((double)z < this.area.f_82293_) {
                    block11: {
                        pos.m_122178_(x, y, z);
                        BlockEntity entity = level.m_7702_((BlockPos)pos);
                        if (entity instanceof RandomizableContainerBlockEntity) {
                            Optional lootTable;
                            RandomizableContainerBlockEntity container = (RandomizableContainerBlockEntity)entity;
                            if (container.f_59605_ == null) {
                                for (int i = 0; i < container.m_6643_(); ++i) {
                                    if (container.m_8020_(i).m_41619_()) {
                                        continue;
                                    }
                                    break block11;
                                }
                                Formations.LOGGER.warn("Template '" + this.name + "' has an empty '" + TextComponents.blockState((BlockState)container.m_58900_()).format() + "' at {x=" + pos.m_123341_() + ", y=" + pos.m_123342_() + ", z=" + pos.m_123343_() + "}!");
                            } else if (level.m_7654_() != null && (lootTable = level.m_7654_().m_278653_().m_278615_(LootDataType.f_278413_, container.f_59605_)).isEmpty()) {
                                Formations.LOGGER.warn("Template '" + this.name + "' has a '" + TextComponents.blockState((BlockState)container.m_58900_()).format() + "' at {x=" + pos.m_123341_() + ", y=" + pos.m_123342_() + ", z=" + pos.m_123343_() + "} with missing loot table '" + container.f_59605_ + "'!");
                            }
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        StructureTemplate structure = new StructureTemplate();
        structure.m_163802_(level, new BlockPos((int)this.area.f_82288_, (int)this.area.f_82289_, (int)this.area.f_82290_), new Vec3i((int)this.area.m_82362_(), (int)this.area.m_82376_(), (int)this.area.m_82385_()), true, Blocks.f_50454_);
        CompoundTag data = structure.m_74618_(new CompoundTag());
        try {
            Files.createDirectories(output.getParent(), new FileAttribute[0]);
            NbtIo.m_128944_((CompoundTag)data, (File)output.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public CompoundTag write() {
        CompoundTag data = new CompoundTag();
        data.m_128347_("areaMinX", this.area.f_82288_);
        data.m_128347_("areaMinY", this.area.f_82289_);
        data.m_128347_("areaMinZ", this.area.f_82290_);
        data.m_128347_("areaMaxX", this.area.f_82291_);
        data.m_128347_("areaMaxY", this.area.f_82292_);
        data.m_128347_("areaMaxZ", this.area.f_82293_);
        data.m_128359_("name", this.name);
        return data;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeDouble(this.area.f_82288_);
        buffer.writeDouble(this.area.f_82289_);
        buffer.writeDouble(this.area.f_82290_);
        buffer.writeDouble(this.area.f_82291_);
        buffer.writeDouble(this.area.f_82292_);
        buffer.writeDouble(this.area.f_82293_);
        buffer.m_130070_(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        if (!this.area.equals((Object)template.area)) {
            return false;
        }
        return this.name.equals(template.name);
    }

    public int hashCode() {
        int result = this.area.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }
}

