/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import org.jetbrains.annotations.NotNull;

public class BiomeReplacementProcessor
extends StructureProcessor
implements FormationsStructureProcessor {
    public static final Codec<BiomeReplacementProcessor> CODEC = Codec.unit(BiomeReplacementProcessor::new);
    private static final Map<ResourceKey<Biome>, Map<Block, Block>> BIOME_REPLACEMENT_MAP = new HashMap<ResourceKey<Biome>, Map<Block, Block>>();
    private static final Map<ResourceKey<Biome>, Map<Block, Block>> BIOME_SOIL_REPLACEMENT_MAP = new HashMap<ResourceKey<Biome>, Map<Block, Block>>();
    private static final Set<Block> REPLACEABLE_BLOCKS = new HashSet<Block>();

    @SafeVarargs
    private static void addReplacements(Pair<Block, List<ResourceKey<Biome>>> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            Pair<Block, List<ResourceKey<Biome>>> entry = entries[i];
            for (ResourceKey biome : (List)entry.getSecond()) {
                BIOME_REPLACEMENT_MAP.computeIfAbsent((ResourceKey<Biome>)biome, o -> new HashMap());
                REPLACEABLE_BLOCKS.add((Block)entry.getFirst());
                for (int j = 0; j < entries.length; ++j) {
                    if (i == j || entries[j].getFirst() == entry.getFirst() || entries[j].getFirst() == null) continue;
                    BIOME_REPLACEMENT_MAP.get(biome).put((Block)entries[j].getFirst(), (Block)entry.getFirst());
                }
            }
        }
    }

    @SafeVarargs
    private static void addSoilReplacements(Pair<Block, List<ResourceKey<Biome>>> ... entries) {
        for (int i = 0; i < entries.length; ++i) {
            Pair<Block, List<ResourceKey<Biome>>> entry = entries[i];
            for (ResourceKey biome : (List)entry.getSecond()) {
                BIOME_SOIL_REPLACEMENT_MAP.computeIfAbsent((ResourceKey<Biome>)biome, o -> new HashMap());
                REPLACEABLE_BLOCKS.add((Block)entry.getFirst());
                for (int j = 0; j < entries.length; ++j) {
                    if (i == j || entries[j].getFirst() == entry.getFirst() || entries[j].getFirst() == null) continue;
                    BIOME_SOIL_REPLACEMENT_MAP.get(biome).put((Block)entries[j].getFirst(), (Block)entry.getFirst());
                }
            }
        }
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, BlockPos pos, LevelReader level, BlockPos piecePosition, BlockPos structurePosition, StructurePlaceSettings placeSettings, Map<BlockPos, BlockInstance> pieceBlocks) {
        BlockState newState;
        BlockInstance blockAbove;
        BlockState originalState = block.state();
        if (originalState == null || originalState.m_60713_(Blocks.f_50016_) || !REPLACEABLE_BLOCKS.contains(originalState.m_60734_())) {
            return block;
        }
        BoundingBox boundingBox = placeSettings.m_74409_();
        if (boundingBox == null) {
            return block;
        }
        Holder biomeHolder = level.m_204166_(structurePosition);
        if (!biomeHolder.m_203633_()) {
            return block;
        }
        ResourceKey biome = (ResourceKey)biomeHolder.m_203543_().get();
        Map<Block, Block> replacements = BIOME_SOIL_REPLACEMENT_MAP.get(biome);
        if (!(replacements != null && replacements.containsKey(originalState.m_60734_()) && !((blockAbove = pieceBlocks.get(pos.m_7494_())) != null && blockAbove.state() != null ? blockAbove.state() : level.m_8055_(pos.m_7494_())).m_60783_((BlockGetter)level, pos.m_7494_(), Direction.DOWN) || (replacements = BIOME_REPLACEMENT_MAP.get(biome)) != null && replacements.containsKey(originalState.m_60734_()))) {
            return block;
        }
        return new BlockInstance(newState, (newState = replacements.get(originalState.m_60734_()).m_152465_(originalState)).m_60713_(block.state().m_60734_()) ? block.nbt() : null);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)FormationsStructures.BIOME_REPLACEMENT_PROCESSOR.get();
    }

    static {
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50705_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50741_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220865_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50742_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50745_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50744_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50743_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244477_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271304_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50655_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50656_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50086_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50269_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220848_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50270_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50373_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50372_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50271_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_243755_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271206_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50667_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50668_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50398_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50399_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220851_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50400_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50403_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50402_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50401_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244004_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271301_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50657_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50658_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_49999_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50000_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220832_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50001_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50004_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50003_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50002_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_256831_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271170_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50695_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50686_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50011_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50012_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220836_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50013_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50043_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50015_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50014_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_256831_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271348_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50697_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50688_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50010_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50005_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220835_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50006_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50009_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50008_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50007_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_256740_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271326_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50696_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50687_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50044_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50045_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220837_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50046_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50049_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50048_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50047_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_256740_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271145_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50698_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50689_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50050_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50051_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220838_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50052_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50055_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50054_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50053_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_)), Pair.of((Object)Blocks.f_271115_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50451_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50692_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50154_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50484_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220853_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50485_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50488_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50487_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50486_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244648_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271169_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50671_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50672_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50216_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50217_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220842_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50218_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50221_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50220_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50219_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244549_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271350_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50663_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50664_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50095_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50149_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220841_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50150_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50153_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50151_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50152_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244433_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271516_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50673_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50674_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50158_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50159_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220839_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50160_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50163_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50161_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50162_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244608_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271107_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50675_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50676_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_244319_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_244633_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_244485_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_243890_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_243960_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_243716_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_244263_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244091_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271116_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_244147_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_244396_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_244093_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_243895_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_244385_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_244296_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_243998_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_243773_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_243897_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244462_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271427_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_244281_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_244241_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50132_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50479_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220852_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50480_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50483_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50482_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50481_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244641_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271219_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50661_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50662_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50192_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50474_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220850_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50475_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50478_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50477_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50476_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244313_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271274_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50665_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50666_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50167_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50168_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220840_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50169_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50172_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50171_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50170_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244183_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271227_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50659_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50660_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50251_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50252_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220846_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50253_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50309_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50308_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50254_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_244625_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271396_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50669_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50670_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50746_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186753_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_50747_, List.of(Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_)), Pair.of((Object)Blocks.f_220831_, List.of(Biomes.f_48207_, Biomes.f_220595_)), Pair.of((Object)Blocks.f_50748_, List.of(Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_)), Pair.of((Object)Blocks.f_50751_, List.of(Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_)), Pair.of((Object)Blocks.f_50750_, List.of(Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_50036_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50749_, List.of(Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_)), Pair.of((Object)Blocks.f_50570_, List.of(Biomes.f_48197_)), Pair.of((Object)Blocks.f_271334_, List.of(Biomes.f_271432_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_, Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50225_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50063_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50395_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152593_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50224_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50471_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50473_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152594_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50222_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50062_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50394_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152589_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50194_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50263_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50397_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152590_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50411_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50406_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50467_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152591_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50609_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50613_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50606_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152592_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50470_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50064_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50396_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152555_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50405_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_)), Pair.of((Object)Blocks.f_50407_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50468_, List.of(Biomes.f_186753_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_152557_, List.of(Biomes.f_220594_)));
        BiomeReplacementProcessor.addSoilReplacements(Pair.of((Object)Blocks.f_50440_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_49992_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_49993_, List.of(Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_50137_, List.of(Biomes.f_48175_)), Pair.of((Object)Blocks.f_50136_, List.of(Biomes.f_48199_)), Pair.of((Object)Blocks.f_50134_, List.of(Biomes.f_48209_)), Pair.of((Object)Blocks.f_50699_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50690_, List.of(Biomes.f_48201_)), Pair.of((Object)Blocks.f_50259_, List.of(Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_152481_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48203_, Biomes.f_48159_, Biomes.f_48194_)), Pair.of((Object)Blocks.f_50135_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_, Biomes.f_48200_, Biomes.f_48201_)), Pair.of((Object)Blocks.f_50259_, List.of(Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50493_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_220594_)), Pair.of((Object)Blocks.f_49992_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50352_, List.of(Biomes.f_48159_, Biomes.f_48194_, Biomes.f_186753_)), Pair.of((Object)Blocks.f_50137_, List.of(Biomes.f_48175_)), Pair.of((Object)Blocks.f_50136_, List.of(Biomes.f_48199_)), Pair.of((Object)Blocks.f_50134_, List.of(Biomes.f_48209_, Biomes.f_48200_, Biomes.f_48201_)), Pair.of((Object)Blocks.f_50259_, List.of(Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50069_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_220594_, Biomes.f_48203_)), Pair.of((Object)Blocks.f_50352_, List.of(Biomes.f_48159_, Biomes.f_48194_, Biomes.f_186753_)), Pair.of((Object)Blocks.f_50137_, List.of(Biomes.f_48175_)), Pair.of((Object)Blocks.f_50134_, List.of(Biomes.f_48199_, Biomes.f_48209_, Biomes.f_48200_, Biomes.f_48201_)), Pair.of((Object)Blocks.f_50259_, List.of(Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50034_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48175_, Biomes.f_48209_, Biomes.f_48199_)), Pair.of((Object)Blocks.f_50654_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50693_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50034_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50036_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_, Biomes.f_48200_)), Pair.of((Object)Blocks.f_50653_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50111_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50112_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50072_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50113_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50114_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50115_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50116_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50117_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_, Biomes.f_48200_, Biomes.f_48201_)), Pair.of((Object)Blocks.f_50072_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50118_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50119_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50120_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50121_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
        BiomeReplacementProcessor.addReplacements(Pair.of((Object)Blocks.f_50071_, List.of(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_48205_, Biomes.f_48179_, Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_48217_, Biomes.f_186760_, Biomes.f_151784_, Biomes.f_186761_, Biomes.f_48182_, Biomes.f_186763_, Biomes.f_186764_, Biomes.f_48206_, Biomes.f_48152_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186758_, Biomes.f_186759_, Biomes.f_48212_, Biomes.f_48148_, Biomes.f_48211_, Biomes.f_48172_, Biomes.f_48207_, Biomes.f_220595_, Biomes.f_48149_, Biomes.f_186762_, Biomes.f_48208_, Biomes.f_48151_, Biomes.f_48166_, Biomes.f_48167_, Biomes.f_48170_, Biomes.f_48174_, Biomes.f_48225_, Biomes.f_48168_, Biomes.f_48171_, Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_, Biomes.f_48222_, Biomes.f_186769_, Biomes.f_151785_, Biomes.f_48197_, Biomes.f_271432_, Biomes.f_186753_, Biomes.f_220594_, Biomes.f_48159_, Biomes.f_48194_, Biomes.f_48210_, Biomes.f_48164_, Biomes.f_48163_, Biomes.f_48162_, Biomes.f_48165_)), Pair.of((Object)Blocks.f_50016_, List.of(Biomes.f_48203_)), Pair.of((Object)Blocks.f_50073_, List.of(Biomes.f_48199_, Biomes.f_48175_, Biomes.f_48209_)), Pair.of((Object)Blocks.f_50700_, List.of(Biomes.f_48200_)), Pair.of((Object)Blocks.f_50691_, List.of(Biomes.f_48201_)));
    }
}

