/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.util.formulae;

import com.flansmod.util.formulae.EAccumulationOperation;
import com.flansmod.util.formulae.FloatAccumulation;
import com.flansmod.util.formulae.FloatFormula;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class FloatAccumulator<TInputEnum extends Enum<TInputEnum>, TFormulaType extends FloatFormula<? extends TInputEnum>> {
    private final TFormulaType BaseAdd = this.FormulaConstructor();
    private final TFormulaType StackableMultiplier = this.FormulaConstructor();
    private final List<TFormulaType> IndependentMultipliers = new ArrayList<TFormulaType>();
    private final TFormulaType FinalAdd = this.FormulaConstructor();

    @Nonnull
    protected abstract TFormulaType FormulaConstructor();

    @Nonnull
    protected abstract TFormulaType ConstEmptyFormula();

    @Nonnull
    public FloatAccumulator<TInputEnum, TFormulaType> CopyFrom(@Nonnull FloatAccumulator<TInputEnum, TFormulaType> other) {
        ((FloatFormula)this.BaseAdd).AddTerms(((FloatFormula)other.BaseAdd).Terms);
        ((FloatFormula)this.StackableMultiplier).AddTerms(((FloatFormula)other.StackableMultiplier).Terms);
        for (int i = 0; i < other.IndependentMultipliers.size(); ++i) {
            TFormulaType copyFormula = this.FormulaConstructor();
            ((FloatFormula)copyFormula).AddTerms(((FloatFormula)other.IndependentMultipliers.get((int)i)).Terms);
            this.IndependentMultipliers.add(copyFormula);
        }
        ((FloatFormula)this.FinalAdd).AddTerms(((FloatFormula)other.FinalAdd).Terms);
        return this;
    }

    @Nonnull
    public FloatAccumulator<TInputEnum, TFormulaType> BaseAdd(float constant) {
        this.BaseAdd.AddTerm(constant, new Enum[0]);
        return this;
    }

    @Nonnull
    public FloatAccumulator<TInputEnum, TFormulaType> StackableMultiplier(float constant) {
        this.StackableMultiplier.AddTerm(constant, new Enum[0]);
        return this;
    }

    @Nonnull
    public FloatAccumulator<TInputEnum, TFormulaType> IndependentMultiplier(float constant) {
        this.GetFormulaFor(EAccumulationOperation.IndependentPercentage).AddTerm(constant, new Enum[0]);
        return this;
    }

    @Nonnull
    public FloatAccumulator<TInputEnum, TFormulaType> FinalAdd(float constant) {
        this.FinalAdd.AddTerm(constant, new Enum[0]);
        return this;
    }

    @Nonnull
    public FloatAccumulator<TInputEnum, TFormulaType> Bake(@Nonnull TInputEnum inputType, float value) {
        int inputTypeIndex = ((Enum)inputType).ordinal();
        ((FloatFormula)this.BaseAdd).BakeInput((int)inputTypeIndex, value);
        ((FloatFormula)this.StackableMultiplier).BakeInput((int)inputTypeIndex, value);
        for (FloatFormula formula : this.IndependentMultipliers) {
            formula.BakeInput(inputTypeIndex, value);
        }
        ((FloatFormula)this.FinalAdd).BakeInput((int)inputTypeIndex, value);
        return this;
    }

    @Nonnull
    protected TFormulaType GetFormulaFor(@Nonnull EAccumulationOperation operation) {
        switch (operation) {
            case BaseAdd: {
                return this.BaseAdd;
            }
            case StackablePercentage: {
                return this.StackableMultiplier;
            }
            case FinalAdd: {
                return this.FinalAdd;
            }
            case IndependentPercentage: {
                TFormulaType newIndependentMul = this.FormulaConstructor();
                this.IndependentMultipliers.add(newIndependentMul);
                return newIndependentMul;
            }
        }
        return this.ConstEmptyFormula();
    }

    @Nonnull
    public FloatAccumulation GetDefaultValue() {
        return this.Evaluate(enumIndex -> Float.valueOf(0.0f));
    }

    @Nonnull
    public FloatAccumulation Evaluate(@Nonnull Function<Integer, Float> sources) {
        float baseAdd = ((FloatFormula)this.BaseAdd).Evaluate(sources);
        float stackMul = ((FloatFormula)this.StackableMultiplier).Evaluate(sources);
        float indepMul = 1.0f;
        for (FloatFormula formula : this.IndependentMultipliers) {
            indepMul *= formula.Evaluate(sources);
        }
        float finalAdd = ((FloatFormula)this.FinalAdd).Evaluate(sources);
        return FloatAccumulation.of(baseAdd, stackMul, indepMul, finalAdd);
    }
}

