/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.server.command;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.collision.ColliderHandle;
import com.flansmod.physics.common.collision.ICollisionSystem;
import com.flansmod.physics.common.collision.obb.OBBCollisionSystem;
import com.flansmod.physics.common.entity.PhysicsEntity;
import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.LinearAcceleration;
import com.flansmod.physics.common.units.LinearVelocity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CommandPhysicsDebug {
    private static final Vec3 DEFAULT_YEET = new Vec3(0.0, 1.0, 0.0);
    private static final Vec3 DEFAULT_SPIN_AXIS = new Vec3(0.0, 1.0, 0.0);
    private static final double DEFAULT_SPIN_DEGREES_PER_S = 30.0;

    public static void register(@Nonnull CommandDispatcher<CommandSourceStack> dispatch, @Nonnull CommandBuildContext context) {
        dispatch.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"physics").requires(player -> player.m_6761_(2))).then(Commands.m_82127_((String)"toggle").executes(ctx -> CommandPhysicsDebug.PausePhysicsToggle((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"pause").executes(ctx -> CommandPhysicsDebug.PausePhysics((CommandSourceStack)ctx.getSource(), true)))).then(Commands.m_82127_((String)"resume").executes(ctx -> CommandPhysicsDebug.PausePhysics((CommandSourceStack)ctx.getSource(), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"inspect").executes(ctx -> CommandPhysicsDebug.DebugInspectCycle((CommandSourceStack)ctx.getSource(), 1))).then(Commands.m_82127_((String)"next").executes(ctx -> CommandPhysicsDebug.DebugInspectCycle((CommandSourceStack)ctx.getSource(), 1)))).then(Commands.m_82127_((String)"prev").executes(ctx -> CommandPhysicsDebug.DebugInspectCycle((CommandSourceStack)ctx.getSource(), -1)))).then(Commands.m_82127_((String)"clear").executes(ctx -> CommandPhysicsDebug.DebugInspectSetIndex((CommandSourceStack)ctx.getSource(), 0)))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"index", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandPhysicsDebug.DebugInspectSetIndex((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"index")))))).then(Commands.m_82127_((String)"closest").executes(ctx -> CommandPhysicsDebug.DebugInspectSetClosest((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"yeet").executes(ctx -> CommandPhysicsDebug.DebugYeet((CommandSourceStack)ctx.getSource(), DEFAULT_YEET))).then(Commands.m_82129_((String)"velocity", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CommandPhysicsDebug.DebugYeet((CommandSourceStack)ctx.getSource(), Vec3Argument.m_120844_((CommandContext)ctx, (String)"velocity"))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> CommandPhysicsDebug.DebugYeet((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), DEFAULT_YEET))).then(Commands.m_82129_((String)"velocity", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CommandPhysicsDebug.DebugYeet((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), Vec3Argument.m_120844_((CommandContext)ctx, (String)"velocity"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"spin").executes(ctx -> CommandPhysicsDebug.DebugSpin((CommandSourceStack)ctx.getSource(), DEFAULT_SPIN_AXIS, 30.0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"degrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> CommandPhysicsDebug.DebugSpin((CommandSourceStack)ctx.getSource(), DEFAULT_SPIN_AXIS, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"degrees")))).then(Commands.m_82129_((String)"axis", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CommandPhysicsDebug.DebugSpin((CommandSourceStack)ctx.getSource(), Vec3Argument.m_120844_((CommandContext)ctx, (String)"axis"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"degrees")))))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).executes(ctx -> CommandPhysicsDebug.DebugSpin((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), DEFAULT_SPIN_AXIS, 30.0))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"degrees", (ArgumentType)DoubleArgumentType.doubleArg()).executes(ctx -> CommandPhysicsDebug.DebugSpin((CommandSourceStack)ctx.getSource(), DEFAULT_SPIN_AXIS, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"degrees")))).then(Commands.m_82129_((String)"axis", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> CommandPhysicsDebug.DebugSpin((CommandSourceStack)ctx.getSource(), EntityArgument.m_91461_((CommandContext)ctx, (String)"targets"), Vec3Argument.m_120844_((CommandContext)ctx, (String)"axis"), DoubleArgumentType.getDouble((CommandContext)ctx, (String)"degrees"))))))));
    }

    private static int PausePhysicsToggle(@Nonnull CommandSourceStack source) {
        boolean bl = FlansPhysicsMod.PAUSE_PHYSICS = !FlansPhysicsMod.PAUSE_PHYSICS;
        if (FlansPhysicsMod.PAUSE_PHYSICS) {
            source.m_288197_(() -> Component.m_237115_((String)"flansphysics.command.physics_pause"), true);
        } else {
            source.m_288197_(() -> Component.m_237115_((String)"flansphysics.command.physics_resume"), true);
        }
        return -1;
    }

    private static int PausePhysics(@Nonnull CommandSourceStack source, boolean pause) {
        FlansPhysicsMod.PAUSE_PHYSICS = pause;
        if (pause) {
            source.m_288197_(() -> Component.m_237115_((String)"flansphysics.command.physics_pause"), true);
        } else {
            source.m_288197_(() -> Component.m_237115_((String)"flansphysics.command.physics_resume"), true);
        }
        return -1;
    }

    private static int DebugInspectCycle(@Nonnull CommandSourceStack source, int delta) {
        ColliderHandle newHandle = OBBCollisionSystem.Debug_CycleInspectHandle((Level)source.m_81372_(), delta);
        source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.cycle_inspect", (Object[])new Object[]{newHandle.Handle()}), true);
        return -1;
    }

    private static int DebugInspectSetIndex(@Nonnull CommandSourceStack source, int index) {
        ColliderHandle newHandle = OBBCollisionSystem.Debug_SetInspectHandleIndex((Level)source.m_81372_(), index);
        source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.select_handle", (Object[])new Object[]{newHandle.Handle(), index, OBBCollisionSystem.Debug_GetNumHandles((Level)source.m_81372_())}), true);
        return -1;
    }

    private static int DebugInspectSetClosest(@Nonnull CommandSourceStack source) {
        ColliderHandle newHandle = OBBCollisionSystem.Debug_SetNearestInspectHandle((Level)source.m_81372_(), source.m_81371_());
        source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.select_closest", (Object[])new Object[]{newHandle.Handle()}), true);
        return -1;
    }

    private static int DebugYeet(@Nonnull CommandSourceStack source, @Nonnull Vec3 yeetVector) {
        ColliderHandle handle = OBBCollisionSystem.DEBUG_HANDLE;
        if (handle.IsValid()) {
            OBBCollisionSystem system = OBBCollisionSystem.ForLevel((Level)source.m_81372_());
            LinearAcceleration acc = LinearAcceleration.fromUtoVinTicks(LinearVelocity.Zero, LinearVelocity.blocksPerSecond(yeetVector), 1);
            system.addLinearAcceleration(handle, acc);
            source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.yeet_single", (Object[])new Object[]{acc.toFancyString(), handle.Handle()}), true);
        }
        return -1;
    }

    private static int DebugYeet(@Nonnull CommandSourceStack source, @Nonnull Collection<? extends Entity> entities, @Nonnull Vec3 yeetVector) {
        LinearAcceleration acc = LinearAcceleration.fromUtoVinTicks(LinearVelocity.Zero, LinearVelocity.blocksPerSecond(yeetVector), 1);
        int entityCount = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof PhysicsEntity)) continue;
            PhysicsEntity physicsEntity = (PhysicsEntity)entity;
            OBBCollisionSystem system = OBBCollisionSystem.ForLevel(entity.m_9236_());
            physicsEntity.forEachPhysicsComponent(component -> component.getPendingForces().addForce(acc.multiplyBy(component.mass)));
            ++entityCount;
        }
        int entCountCopy = entityCount;
        source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.yeet_multiple", (Object[])new Object[]{acc.toFancyString(), entCountCopy}), true);
        return -1;
    }

    private static int DebugSpin(@Nonnull CommandSourceStack source, @Nonnull Vec3 spinAxis, double spinSpeed) {
        ColliderHandle handle = OBBCollisionSystem.DEBUG_HANDLE;
        if (handle.IsValid()) {
            ICollisionSystem system = FlansPhysicsMod.forLevel((Level)source.m_81372_());
            AngularAcceleration acc = AngularAcceleration.fromUtoVinTicks(AngularVelocity.Zero, AngularVelocity.degreesPerSecond(spinAxis.m_82541_(), spinSpeed), 1);
            system.applyTorque(handle, acc.asTorqueForPointMass(1.0));
            source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.yeet_single", (Object[])new Object[]{acc.toFancyString(), handle.Handle()}), true);
        }
        return -1;
    }

    private static int DebugSpin(@Nonnull CommandSourceStack source, @Nonnull Collection<? extends Entity> entities, @Nonnull Vec3 spinAxis, double spinSpeed) {
        AngularAcceleration acc = AngularAcceleration.fromUtoVinTicks(AngularVelocity.Zero, AngularVelocity.degreesPerSecond(spinAxis.m_82541_(), spinSpeed), 1);
        int entityCount = 0;
        for (Entity entity : entities) {
            if (!(entity instanceof PhysicsEntity)) continue;
            PhysicsEntity physicsEntity = (PhysicsEntity)entity;
            physicsEntity.forEachPhysicsComponent(component -> component.getPendingForces().addForce(acc.asTorqueForPointMass(component.mass)));
            ++entityCount;
        }
        int entCountCopy = entityCount;
        source.m_288197_(() -> Component.m_237110_((String)"flansphysics.command.yeet_multiple", (Object[])new Object[]{acc.toFancyString(), entCountCopy}), true);
        return -1;
    }
}

