/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.network;

import com.flansmod.physics.common.units.AngularVelocity;
import com.flansmod.physics.common.units.LinearVelocity;
import com.flansmod.physics.common.util.Transform;
import com.flansmod.physics.network.PhysicsMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import org.joml.Quaternionf;

public class PhysicsSyncMessage
extends PhysicsMessage {
    public static final UUID INVALID_ID = new UUID(0L, 0L);
    public static final int LOCATION_FLAG = 1;
    public static final int ROLL_FLAG = 2;
    public static final int LINEAR_VELOCITY_FLAG = 4;
    public static final int ANGULAR_VELOCITY_FLAG = 8;
    public int EntityID;
    public long GameTick;
    public List<PhysicsStateChange> StateChanges = new ArrayList<PhysicsStateChange>();

    public void addStateChange(@Nonnull UUID id, @Nullable Transform location, @Nullable LinearVelocity linear, @Nullable AngularVelocity angular) {
        PhysicsStateChange stateChange = new PhysicsStateChange();
        stateChange.PhysicsComponentID = id;
        stateChange.Location = location;
        stateChange.LinearVelocityUpdate = linear;
        stateChange.AngularVelocityUpdate = angular;
        this.StateChanges.add(stateChange);
    }

    @Override
    public void encode(@Nonnull FriendlyByteBuf buf) {
        buf.writeInt(this.EntityID);
        buf.writeLong(this.GameTick);
        buf.writeInt(this.StateChanges.size());
        for (int i = 0; i < this.StateChanges.size(); ++i) {
            PhysicsStateChange change = this.StateChanges.get(i);
            buf.m_130077_(change.PhysicsComponentID);
            int flags = 0;
            if (change.Location != null) {
                flags |= 1;
            }
            if (change.LinearVelocityUpdate != null) {
                flags |= 4;
            }
            if (change.AngularVelocityUpdate != null) {
                flags |= 8;
            }
            buf.writeInt(flags);
            if (change.Location != null) {
                buf.writeDouble(change.Location.Position.x);
                buf.writeDouble(change.Location.Position.y);
                buf.writeDouble(change.Location.Position.z);
                buf.m_269101_(change.Location.Orientation);
            }
            if (change.LinearVelocityUpdate != null) {
                change.LinearVelocityUpdate.toBuf(buf);
            }
            if (change.AngularVelocityUpdate == null) continue;
            change.AngularVelocityUpdate.toBuf(buf);
        }
    }

    @Override
    public void decode(@Nonnull FriendlyByteBuf buf) {
        this.EntityID = buf.readInt();
        this.GameTick = buf.readLong();
        int numStateChanges = buf.readInt();
        for (int i = 0; i < numStateChanges; ++i) {
            PhysicsStateChange change = new PhysicsStateChange();
            change.PhysicsComponentID = buf.m_130259_();
            int flags = buf.readInt();
            if ((flags & 1) != 0) {
                double x = buf.readDouble();
                double y = buf.readDouble();
                double z = buf.readDouble();
                Quaternionf ori = buf.m_269131_();
                change.Location = Transform.fromPosAndQuat(x, y, z, ori);
            }
            if ((flags & 4) != 0) {
                change.LinearVelocityUpdate = LinearVelocity.fromBuf(buf);
            }
            if ((flags & 8) != 0) {
                change.AngularVelocityUpdate = AngularVelocity.fromBuf(buf);
            }
            this.StateChanges.add(change);
        }
    }

    public static class PhysicsStateChange {
        @Nonnull
        public UUID PhysicsComponentID = INVALID_ID;
        @Nullable
        public Transform Location;
        @Nullable
        public LinearVelocity LinearVelocityUpdate;
        @Nullable
        public AngularVelocity AngularVelocityUpdate;
    }

    public static class ToClient
    extends PhysicsSyncMessage {
    }

    public static class ToServer
    extends PhysicsSyncMessage {
    }
}

