/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.util;

import com.flansmod.physics.common.FlansPhysicsMod;
import com.flansmod.physics.common.util.Transform;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TransformStack {
    private final Stack<Layer> Layers = new Stack();

    @Nonnull
    public Transform top() {
        return this.localToGlobalTransform(Transform.IDENTITY);
    }

    @Nonnull
    public Vec3 forward() {
        return this.localToGlobalDirection(new Vec3(0.0, 0.0, -1.0));
    }

    @Nonnull
    public Vec3 right() {
        return this.localToGlobalDirection(new Vec3(1.0, 0.0, 0.0));
    }

    @Nonnull
    public Vec3 up() {
        return this.localToGlobalDirection(new Vec3(0.0, 1.0, 0.0));
    }

    private TransformStack() {
        this.Layers.push(new Layer(new Stack<Transform>(), null));
    }

    private TransformStack(@Nonnull Matrix4f pose) {
        this();
        boolean flip;
        Vector3d pos = new Vector3d((Vector3fc)pose.transformPosition(new Vector3f()));
        Vector3f right = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f back = new Vector3f(0.0f, 0.0f, 1.0f);
        pose.transformDirection(right);
        pose.transformDirection(up);
        pose.transformDirection(back);
        Vector3f scale = new Vector3f(right.length(), up.length(), back.length());
        Matrix3f oriMatrix = new Matrix3f(right.x / scale.x, right.y / scale.y, right.z / scale.z, up.x / scale.x, up.y / scale.y, up.z / scale.z, back.x / scale.x, back.y / scale.y, back.z / scale.z);
        boolean bl = flip = oriMatrix.determinant() < 0.0f;
        if (flip) {
            scale.x = -scale.x;
            oriMatrix.m00 = -oriMatrix.m00;
            oriMatrix.m10 = -oriMatrix.m10;
            oriMatrix.m20 = -oriMatrix.m20;
        }
        Quaternionf orientation = oriMatrix.getNormalizedRotation(new Quaternionf());
        orientation.normalize();
        this.add(Transform.fromScale(scale));
        this.add(Transform.fromPosAndQuat(pos.x / (double)scale.x, pos.y / (double)scale.y, pos.z / (double)scale.z, orientation));
    }

    @Nonnull
    public static TransformStack empty() {
        return new TransformStack();
    }

    @Nonnull
    public static TransformStack of() {
        return new TransformStack();
    }

    @Nonnull
    public static TransformStack of(@Nonnull Transform transform) {
        return new TransformStack().and(transform);
    }

    @Nonnull
    public static TransformStack of(Transform ... transforms) {
        return new TransformStack().and(transforms);
    }

    @Nonnull
    public static TransformStack of(@Nonnull Matrix4f pose) {
        return new TransformStack(pose);
    }

    @Nonnull
    public static TransformStack of(@Nonnull PoseStack poseStack) {
        return TransformStack.of(poseStack.m_85850_().m_252922_());
    }

    @Nonnull
    public TransformStack and(@Nonnull Transform transform) {
        this.add(transform);
        return this;
    }

    @Nonnull
    public TransformStack and(Transform ... transforms) {
        this.addAll(transforms);
        return this;
    }

    public void add(@Nonnull Transform transform) {
        this.Layers.peek().transforms.add(transform);
    }

    public void addAll(Transform ... transforms) {
        this.Layers.peek().transforms.addAll(Arrays.asList(transforms));
    }

    public void push() {
        this.Layers.push(new Layer(new Stack<Transform>(), null));
    }

    public void push(@Nonnull String debugInfo) {
        this.Layers.push(new Layer(new Stack<Transform>(), debugInfo));
    }

    public void pop() {
        if (this.Layers.size() > 1) {
            this.Layers.pop();
        } else {
            FlansPhysicsMod.LOGGER.error("Uneven push/pop in TransformStack");
        }
    }

    @Nonnull
    public Vec3 localToGlobalDirection(@Nonnull Vec3 localDirection) {
        return this.iterateDown(Transform::localToGlobalDirection, localDirection);
    }

    @Nonnull
    public Vec3 globalToLocalDirection(@Nonnull Vec3 globalDirection) {
        return this.iterateUp(Transform::globalToLocalDirection, globalDirection);
    }

    @Nonnull
    public Vec3 localToGlobalPosition(@Nonnull Vec3 localPosition) {
        return this.iterateDown(Transform::localToGlobalPosition, localPosition);
    }

    @Nonnull
    public Vec3 globalToLocalPosition(@Nonnull Vec3 globalPosition) {
        return this.iterateUp(Transform::globalToLocalPosition, globalPosition);
    }

    @Nonnull
    public Quaternionf localToGlobalOrientation(@Nonnull Quaternionf localOri) {
        return this.iterateDown(Transform::localToGlobalOrientation, localOri);
    }

    @Nonnull
    public Quaternionf globalToLocalOrientation(@Nonnull Quaternionf globalOri) {
        return this.iterateUp(Transform::globalToLocalOrientation, globalOri);
    }

    @Nonnull
    public Transform localToGlobalTransform(@Nonnull Transform localTransform) {
        return this.iterateDown(Transform::localToGlobalTransform, localTransform);
    }

    @Nonnull
    public Transform globalToLocalTransform(@Nonnull Transform globalTransform) {
        return this.iterateUp(Transform::globalToLocalTransform, globalTransform);
    }

    private <T> T iterateUp(@Nonnull BiFunction<Transform, T, T> func, @Nonnull T target) {
        for (int i = 0; i < this.Layers.size(); ++i) {
            target = ((Layer)this.Layers.get(i)).iterateUp(func, target);
        }
        return target;
    }

    private void iterateUp(@Nonnull Consumer<Transform> func) {
        for (int i = 0; i < this.Layers.size(); ++i) {
            ((Layer)this.Layers.get(i)).iterateUp(func);
        }
    }

    private <T> T iterateDown(@Nonnull BiFunction<Transform, T, T> func, @Nonnull T target) {
        for (int i = this.Layers.size() - 1; i >= 0; --i) {
            target = ((Layer)this.Layers.get(i)).iterateDown(func, target);
        }
        return target;
    }

    private void iterateDown(@Nonnull Consumer<Transform> func) {
        for (int i = this.Layers.size() - 1; i >= 0; --i) {
            ((Layer)this.Layers.get(i)).iterateDown(func);
        }
    }

    public void applyToPoseStack(@Nonnull PoseStack poseStack) {
        this.iterateUp(t -> {
            poseStack.m_85837_(t.Position.x, t.Position.y, t.Position.z);
            poseStack.m_252781_(t.Orientation);
            poseStack.m_85841_(t.Scale.x, t.Scale.y, t.Scale.z);
        });
    }

    public void scale(float x, float y, float z) {
        this.add(Transform.fromScale(new Vector3f(x, y, z)));
    }

    public void translate(double x, double y, double z) {
        this.add(Transform.fromPos(x, y, z));
    }

    public void mulPose(@Nonnull Quaternionf rot) {
        this.add(Transform.fromPosAndQuat(new Vector3d(), rot));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void debugRender(int ticks) {
        Vec3 prevAxesPos = Vec3.f_82478_;
    }

    private record Layer(@Nonnull Stack<Transform> transforms, @Nullable String debugInfo) {
        @Nonnull
        public Vec3 localToGlobalDirection(@Nonnull Vec3 localDirection) {
            return this.iterateDown(Transform::localToGlobalDirection, localDirection);
        }

        @Nonnull
        public Vec3 globalToLocalDirection(@Nonnull Vec3 globalDirection) {
            return this.iterateUp(Transform::globalToLocalDirection, globalDirection);
        }

        @Nonnull
        public Vec3 localToGlobalPosition(@Nonnull Vec3 localPosition) {
            return this.iterateDown(Transform::localToGlobalPosition, localPosition);
        }

        @Nonnull
        public Vec3 globalToLocalPosition(@Nonnull Vec3 globalPosition) {
            return this.iterateUp(Transform::globalToLocalPosition, globalPosition);
        }

        @Nonnull
        public Quaternionf localToGlobalOrientation(@Nonnull Quaternionf localOri) {
            return this.iterateDown(Transform::localToGlobalOrientation, localOri);
        }

        @Nonnull
        public Quaternionf globalToLocalOrientation(@Nonnull Quaternionf globalOri) {
            return this.iterateUp(Transform::globalToLocalOrientation, globalOri);
        }

        @Nonnull
        public Transform localToGlobalTransform(@Nonnull Transform localTransform) {
            return this.iterateDown(Transform::localToGlobalTransform, localTransform);
        }

        @Nonnull
        public Transform globalToLocalTransform(@Nonnull Transform globalTransform) {
            return this.iterateUp(Transform::globalToLocalTransform, globalTransform);
        }

        private <T> T iterateUp(@Nonnull BiFunction<Transform, T, T> func, @Nonnull T target) {
            for (int i = 0; i < this.transforms.size(); ++i) {
                target = func.apply((Transform)this.transforms.get(i), (Transform)target);
            }
            return target;
        }

        private void iterateUp(@Nonnull Consumer<Transform> func) {
            for (int i = 0; i < this.transforms.size(); ++i) {
                func.accept((Transform)this.transforms.get(i));
            }
        }

        private <T> T iterateDown(@Nonnull BiFunction<Transform, T, T> func, @Nonnull T target) {
            for (int i = this.transforms.size() - 1; i >= 0; --i) {
                target = func.apply((Transform)this.transforms.get(i), (Transform)target);
            }
            return target;
        }

        private void iterateDown(@Nonnull Consumer<Transform> func) {
            for (int i = this.transforms.size() - 1; i >= 0; --i) {
                func.accept((Transform)this.transforms.get(i));
            }
        }
    }
}

