/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.physics.common.units;

import com.flansmod.physics.common.units.AngularAcceleration;
import com.flansmod.physics.common.units.IForce;
import com.flansmod.physics.common.units.LinearForce;
import com.flansmod.physics.common.units.Units;
import com.flansmod.physics.common.util.Maths;
import com.flansmod.physics.common.util.Transform;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.NotImplementedException;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;

public record Torque(@Nonnull Vec3 Axis, double Magnitude) implements IForce
{
    public static final Torque Zero = new Torque(new Vec3(0.0, 1.0, 0.0), 0.0);

    @Nonnull
    public static Torque fromKgBlocksSqQuatPerTickSq(@Nonnull Quaternionf quaternionPerTick) {
        if (quaternionPerTick.equals((Quaternionfc)Transform.IDENTITY.Orientation, 1.0E-6f)) {
            return Zero;
        }
        AxisAngle4f axisAngle = new AxisAngle4f().set((Quaternionfc)quaternionPerTick);
        return new Torque(new Vec3((double)axisAngle.x, (double)axisAngle.y, (double)axisAngle.z), axisAngle.angle);
    }

    @Nonnull
    public static Torque fromKgBlocksSqQuatPerSecondSq(@Nonnull Quaternionf quaternionPerSecond) {
        return Torque.fromKgBlocksSqQuatPerTickSq(quaternionPerSecond).scale(0.0025000000000000005);
    }

    @Nonnull
    public static Torque kgBlocksSqPerSecondSq(@Nonnull Vec3 axis, double kgBlocksSqPerSecondSq) {
        return new Torque(axis, Units.Force.KgBlocksPerSecondSq_To_KgBlocksPerTickSq(kgBlocksSqPerSecondSq));
    }

    @Nonnull
    public static Torque kgBlocksSqPerTickSq(@Nonnull Vec3 axis, double kgBlocksSqPerTickSq) {
        return new Torque(axis, kgBlocksSqPerTickSq);
    }

    @Nonnull
    public Vec3 asVec3() {
        return this.Axis.m_82490_(this.Magnitude);
    }

    @Nonnull
    public Torque scale(double scale) {
        return new Torque(this.Axis, this.Magnitude * scale);
    }

    @Nonnull
    public Torque compose(@Nonnull Torque other) {
        Quaternionf torqueA = new Quaternionf().setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        Quaternionf torqueB = new Quaternionf().setAngleAxis(other.Magnitude, other.Axis.f_82479_, other.Axis.f_82480_, other.Axis.f_82481_);
        Quaternionf composed = torqueA.mul((Quaternionfc)torqueB);
        return Torque.fromKgBlocksSqQuatPerTickSq(composed);
    }

    @Nonnull
    public Units.Torque getDefaultUnits() {
        return Units.Torque.KgBlocksSqPerTickSq;
    }

    public Torque convertToUnits(@Nonnull Units.Torque toUnits) {
        return new Torque(this.Axis, Units.Torque.Convert(this.Magnitude, Units.Torque.KgBlocksSqPerTickSq, toUnits));
    }

    @Nonnull
    public AngularAcceleration sumTorqueActingOnMass(double mass) {
        return new AngularAcceleration(this.Axis, this.Magnitude / mass);
    }

    @Nonnull
    public AngularAcceleration sumTorqueActingOnInverseMass(double invMass) {
        return new AngularAcceleration(this.Axis, this.Magnitude * invMass);
    }

    @Nonnull
    public AngularAcceleration actingOnMomentOfInertia(@Nonnull Vec3 momentOfInertia) {
        AxisAngle4d axisAngle = new AxisAngle4d();
        Quaterniond quat = new Quaterniond();
        Vector3d euler = new Vector3d();
        quat.setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        quat.getEulerAnglesXYZ(euler);
        euler.div(momentOfInertia.f_82479_, momentOfInertia.f_82480_, momentOfInertia.f_82481_);
        quat.identity();
        quat.rotateXYZ(euler.x, euler.y, euler.z);
        axisAngle.set((Quaterniondc)quat);
        return new AngularAcceleration(new Vec3(axisAngle.x, axisAngle.y, axisAngle.z), axisAngle.angle);
    }

    @Nonnull
    public AngularAcceleration actingOnInertiaTensor(@Nonnull Vec3 inertiaTensor) {
        AxisAngle4d axisAngle = new AxisAngle4d();
        Quaterniond quat = new Quaterniond();
        Vector3d euler = new Vector3d();
        quat.setAngleAxis(this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_);
        quat.getEulerAnglesXYZ(euler);
        euler.mul(inertiaTensor.f_82479_, inertiaTensor.f_82480_, inertiaTensor.f_82481_);
        quat.identity();
        quat.rotateXYZ(euler.x, euler.y, euler.z);
        axisAngle.set((Quaterniondc)quat);
        return new AngularAcceleration(new Vec3(axisAngle.x, axisAngle.y, axisAngle.z), axisAngle.angle);
    }

    @Override
    public boolean isApproxZero() {
        return Maths.approx(this.Magnitude, 0.0);
    }

    @Override
    @Nonnull
    public Torque inverse() {
        return new Torque(this.Axis, -this.Magnitude);
    }

    @Override
    public boolean hasLinearComponent(@Nonnull Transform actingOn) {
        return false;
    }

    @Override
    @Nonnull
    public LinearForce getLinearComponent(@Nonnull Transform actingOn) {
        throw new NotImplementedException();
    }

    @Override
    public boolean hasAngularComponent(@Nonnull Transform actingOn) {
        return true;
    }

    @Override
    @Nonnull
    public Torque getTorqueComponent(@Nonnull Transform actingOn) {
        return this;
    }

    @Override
    public String toString() {
        return "Torque [" + this.Magnitude + "] around [" + this.Axis + "]";
    }

    @Override
    @Nonnull
    public Component toFancyString() {
        return Component.m_237110_((String)"flansphysics.torque", (Object[])new Object[]{this.Magnitude, this.Axis.f_82479_, this.Axis.f_82480_, this.Axis.f_82481_});
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Torque) {
            Torque otherForce = (Torque)other;
            return otherForce.Axis.equals((Object)this.Axis) && Maths.approx(this.Magnitude, otherForce.Magnitude);
        }
        return false;
    }

    public boolean isApprox(@Nonnull Torque other) {
        return Maths.approx(other.Axis, this.Axis) && Maths.approx(other.Magnitude, this.Magnitude);
    }

    public boolean isApprox(@Nonnull Torque other, double epsilon) {
        return Maths.approx(other.Axis, this.Axis, epsilon) && Maths.approx(other.Magnitude, this.Magnitude, epsilon);
    }
}

